/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;
import untamedwilds.entity.ComplexMobTerrestrial;

public class PandaEatBamboo
extends Goal {
    private final ComplexMobTerrestrial taskOwner;
    private final Sorter sorter;
    private final int executionChance;
    private final int distance;
    private ItemEntity targetItem;
    private Item targetItemStack;

    public PandaEatBamboo(ComplexMobTerrestrial creature, int chance, int distance) {
        this.taskOwner = creature;
        this.executionChance = chance;
        this.sorter = new Sorter((Entity)creature);
        this.distance = distance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.m_6162_() || this.taskOwner.m_5803_()) {
            return false;
        }
        if (this.taskOwner.m_21187_().nextInt(this.executionChance) != 0) {
            return false;
        }
        List list = this.taskOwner.f_19853_.m_45976_(ItemEntity.class, this.getTargetableArea(this.distance));
        list.removeIf(item -> item.m_32055_().m_41720_().equals("bamboo"));
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.targetItem = (ItemEntity)list.get(0);
        this.targetItemStack = this.targetItem.m_32055_().m_41720_();
        return true;
    }

    private AABB getTargetableArea(double targetDistance) {
        return this.taskOwner.m_142469_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    public void m_8056_() {
        this.taskOwner.m_21573_().m_26519_(this.targetItem.m_20185_(), this.targetItem.m_20186_(), this.targetItem.m_20189_(), 1.0);
    }

    public boolean m_8045_() {
        if (this.targetItem == null || !this.targetItem.m_6084_()) {
            return false;
        }
        if (this.taskOwner.isSitting()) {
            return false;
        }
        return !this.taskOwner.m_21691_();
    }

    public void m_8037_() {
        double distance = Math.sqrt(Math.pow(this.taskOwner.m_20185_() - this.targetItem.m_20185_(), 2.0) + Math.pow(this.taskOwner.m_20189_() - this.targetItem.m_20189_(), 2.0));
        if (distance < 1.5) {
            this.taskOwner.addHunger(10);
            this.targetItem.m_32055_().m_41774_(1);
            if (this.targetItem.m_32055_().m_41613_() == 0) {
                this.targetItem.m_146870_();
            }
            this.taskOwner.setAnimation(this.taskOwner.getAnimationEat());
        }
        if (this.taskOwner.m_21573_().m_26571_()) {
            this.m_8041_();
        }
        this.taskOwner.m_21573_().m_26519_(this.targetItem.m_20185_(), this.targetItem.m_20186_(), this.targetItem.m_20189_(), 1.0);
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.m_20280_(entity_1);
            if (dist_1 < (dist_2 = this.entity.m_20280_(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

