/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.MeleeAttackCircle;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.target.HuntWeakerTarget;
import untamedwilds.entity.ai.target.SmartHurtByTargetGoal;
import untamedwilds.entity.ai.unique.SharkSwimmingGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityShark
extends ComplexMobAquatic
implements ISpecies,
IAnimatedEntity,
INeedsPostUpdate,
INewSkins {
    private static final EntityDataAccessor<Boolean> SHORT_FINS = SynchedEntityData.m_135353_(EntityShark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ATTACK_THRASH;
    private int animationTick;
    private Animation currentAnimation;
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public EntityShark(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        ATTACK_THRASH = Animation.create((int)15);
        this.turn_speed = 0.3f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 1.4).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, 50.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackCircle((PathfinderMob)this, 2.3, false, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SharkSwimmingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new SmartHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntWeakerTarget<LivingEntity>(this, LivingEntity.class, true));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.f_19853_.f_46443_) {
            this.setAngry(this.m_5448_() != null);
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.m_146762_(this.getPregnancyTime());
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        }
        if (!this.m_21525_() && !this.m_6162_()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.m_146908_();
                    this.ringBuffer[i][1] = this.m_20186_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.f_19859_ + 0.5f * Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
            this.ringBuffer[this.ringBufferIndex][1] = this.m_20186_();
        }
    }

    public double[] getMovementOffsets(int offset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - offset & 0x3F;
        int j = this.ringBufferIndex - offset - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityShark.class, this.m_142469_().m_82377_(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.m_146764_());
                ((EntityShark)list.get(0)).m_146762_(this.m_146764_());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return this.create_offspring(new EntityShark((EntityType<? extends ComplexMob>)((EntityType)ModEntity.SHARK.get()), this.f_19853_));
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            this.setAnimation(ATTACK_THRASH);
        }
        return flag;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_THRASH};
    }

    public boolean isBottomDweller() {
        return EntityShark.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "bottomDweller") == 1;
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityShark.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityShark.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
        this.setShortFins(EntityShark.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "shortFins") == 1);
    }

    public boolean hasShortFins() {
        return (Boolean)this.f_19804_.m_135370_(SHORT_FINS);
    }

    private void setShortFins(boolean short_fins) {
        this.f_19804_.m_135381_(SHORT_FINS, (Object)short_fins);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasShortFins", this.hasShortFins());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setShortFins(compound.m_128471_("hasShortFins"));
    }
}

