/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousRandomSwimGoal;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.unique.HippoTerritoryTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityHippo
extends ComplexMobAmphibious
implements INewSkins,
ISpecies {
    public static Animation EAT;
    public static Animation IDLE_YAWN;
    public static Animation IDLE_LOOK;
    public static Animation ATTACK;
    public static Animation IDLE_TALK;
    public int angryProgress;

    public EntityHippo(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        IDLE_YAWN = Animation.create((int)36);
        IDLE_LOOK = Animation.create((int)128);
        IDLE_TALK = Animation.create((int)20);
        EAT = Animation.create((int)48);
        ATTACK = Animation.create((int)24);
        this.f_19793_ = 1.0f;
        this.isAmphibious = true;
        this.buoyancy = 0.998f;
        this.turn_speed = 0.3f;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21345_.m_25352_(3, (Goal)new SmartMateGoal(this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new GrazeGoal(this, 10));
        this.f_21345_.m_25352_(4, (Goal)new AmphibiousTransition(this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 0, false));
        this.f_21345_.m_25352_(5, (Goal)new AmphibiousRandomSwimGoal(this, 1.0, 120));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, new HippoTerritoryTargetGoal<LivingEntity>((ComplexMob)this, LivingEntity.class, true, false, input -> !(input instanceof EntityHippo) && !(input instanceof ISpecies) && EntityHippo.getEcoLevel(input) <= EntityHippo.getEcoLevel((LivingEntity)this)));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22282_, 1.6).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.f_146733_ == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            int i;
            if (this.m_20069_() && this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
            }
            if (this.f_19853_.m_46467_() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.m_5634_(1.0f);
                }
            }
            if (!((i = this.f_19796_.nextInt(3000)) > 8 || this.m_20069_() || this.isAngry() || this.m_5803_() || this.getAnimation() != NO_ANIMATION)) {
                this.setAnimation(IDLE_YAWN);
            }
            if (i > 8 && i <= 12 && !this.isAngry() && !this.m_5803_() && this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(IDLE_LOOK);
            }
            if (i == 13 && !this.m_20069_() && this.isNotMoving() && this.canMove() && this.getAnimation() == NO_ANIMATION) {
                this.setSitting(true);
            }
            if (i == 14 && this.isSitting()) {
                this.setSitting(false);
            }
            if (i == 15 && !this.isActive() && !this.m_5803_() && this.m_20069_()) {
                this.setAnimation(IDLE_YAWN);
                this.setSleeping(true);
                this.forceSleep = -800 - this.f_19796_.nextInt(1200);
            }
            if (i > 2980 && !this.m_6162_()) {
                this.setAnimation(IDLE_TALK);
            }
            if (this.getAnimation() == ATTACK && this.m_5448_() != null && this.m_142469_().m_82377_((double)1.2f, 1.0, (double)1.2f).m_82390_(this.m_5448_().m_20318_(0.0f)) && this.getAnimationTick() > 8) {
                LivingEntity target = this.m_5448_();
                this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
                EntityUtils.destroyBoat(this.f_19853_, target);
            }
            this.setAngry(this.m_5448_() != null);
        }
        if (this.getAnimation() != NO_ANIMATION && this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
            this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
        }
        if (this.f_19853_.f_46443_ && this.isAngry() && this.angryProgress < 40) {
            this.angryProgress += 4;
        } else if (this.f_19853_.f_46443_ && !this.isAngry() && this.angryProgress > 0) {
            this.angryProgress -= 4;
        }
        super.m_8107_();
    }

    @Override
    public boolean wantsToBeOnLand() {
        return this.isActive();
    }

    @Override
    public boolean wantsToBeInWater() {
        return !this.isActive();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
        }
        return flag;
    }

    private Animation chooseAttackAnimation() {
        return ATTACK;
    }

    @Nullable
    public EntityHippo getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityHippo((EntityType<? extends ComplexMob>)((EntityType)ModEntity.HIPPO.get()), this.f_19853_));
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, EAT, IDLE_YAWN, IDLE_LOOK, IDLE_TALK, ATTACK};
    }

    @Override
    public Animation getAnimationEat() {
        return EAT;
    }
}

