/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.FollowParentGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.AngrySleeperTarget;
import untamedwilds.entity.ai.target.HuntPackMobTarget;
import untamedwilds.entity.ai.target.HurtPackByTargetGoal;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityHyena
extends ComplexMobTerrestrial
implements INewSkins,
ISpecies,
IPackEntity,
INeedsPostUpdate {
    public static Animation ATTACK_POUNCE;
    public static Animation IDLE_TALK;
    public static Animation ATTACK_BITE;

    public EntityHyena(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        IDLE_TALK = Animation.create((int)20);
        ATTACK_POUNCE = Animation.create((int)42);
        ATTACK_BITE = Animation.create((int)15);
        this.f_19793_ = 1.0f;
        this.turn_speed = 0.1f;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new FindItemsGoal(this, 12, true));
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.8, false, 1.0f, false, false));
        this.f_21345_.m_25352_(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityHyena.getEcoLevel(input) > EntityHyena.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(4, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtPackByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(EntityHyena.class));
        this.f_21346_.m_25352_(2, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityHyena)));
        this.f_21346_.m_25352_(3, new HuntPackMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityHyena.getEcoLevel(input) < EntityHyena.getEcoLevel((LivingEntity)this)));
        this.f_21346_.m_25352_(4, new AngrySleeperTarget<LivingEntity>(this, LivingEntity.class, true));
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 1.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 0.4).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.2);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.f_146733_ == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.herd == null) {
                IPackEntity.initPack(this);
            } else {
                this.herd.tick();
            }
            if (this.f_19853_.m_46467_() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.m_5634_(1.0f);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_() && this.getCommandInt() == 0) {
                int i = this.f_19796_.nextInt(3000);
                if (i == 0 && !this.m_20069_() && this.isNotMoving() && this.canMove() && this.isActive()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                }
                if ((i == 1 || this.m_20069_()) && this.isSitting() && this.getCommandInt() < 2) {
                    this.setSitting(false);
                }
                if (i > 2980 && !this.m_20069_() && !this.m_6162_()) {
                    this.setAnimation(IDLE_TALK);
                }
            }
            this.setAngry(this.m_5448_() != null);
            if (this.getAnimation() == ATTACK_POUNCE && this.getAnimationTick() == 10) {
                this.m_21566_().m_24988_(2.0f, 0.0f);
                this.m_21569_().m_24901_();
            }
            if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
                this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
            }
            if (this.m_5448_() != null && this.f_19797_ % 120 == 0) {
                this.m_5496_(this.getThreatSound(), this.m_6121_(), this.m_6100_());
            }
        }
        if (this.getAnimation() != NO_ANIMATION && this.getAnimation() == ATTACK_BITE && this.getAnimationTick() == 6) {
            this.m_5496_(ModSounds.ENTITY_ATTACK_BITE, 1.5f, 0.8f);
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
        }
        return flag;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    private Animation chooseAttackAnimation() {
        switch (this.f_19796_.nextInt(4)) {
            case 0: {
                return ATTACK_POUNCE;
            }
            case 1: {
                return ATTACK_POUNCE;
            }
        }
        return ATTACK_BITE;
    }

    @Nullable
    public EntityHyena getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityHyena((EntityType<? extends ComplexMob>)((EntityType)ModEntity.HYENA.get()), this.f_19853_));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_() && !this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            if (this.m_21187_().nextInt(3) == 0) {
                this.m_21828_(player);
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_POUNCE, ATTACK_BITE, IDLE_TALK};
    }

    @Override
    public Animation getAnimationEat() {
        return NO_ANIMATION;
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityHyena.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityHyena.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
    }
}

