/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.unique.TortoiseHideInShellGoal;
import untamedwilds.init.ModItems;
import untamedwilds.util.EntityUtils;

public class EntityTortoise
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins {
    public EntityTortoise(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.ticksToSit = 20;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22284_, 10.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 0.7));
        this.f_21345_.m_25352_(2, new TortoiseHideInShellGoal<LivingEntity>(this, LivingEntity.class, 7.0f, input -> EntityTortoise.getEcoLevel(input) > EntityTortoise.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new SmartWanderGoal(this, 1.0, 400, 0, true));
    }

    @Override
    public void m_6667_(DamageSource cause) {
        ItemEntity entityitem;
        if (cause == DamageSource.f_19321_ && !this.m_6162_() && (entityitem = this.m_5552_(new ItemStack((ItemLike)ModItems.FOOD_TURTLE_SOUP.get()), 0.2f)) != null) {
            entityitem.m_32055_().m_41764_(1);
        }
        super.m_6667_(cause);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityTortoise.class, this.m_142469_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityTortoise)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_tortoise", this.getOffspring());
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41619_() && this.m_6084_()) {
            EntityUtils.turnEntityIntoItem((LivingEntity)this, "spawn_tortoise");
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source != DamageSource.f_19315_ && this.sitProgress > 0) {
            amount *= 0.2f;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = this.m_6162_() ? SoundEvents.f_12488_ : SoundEvents.f_12487_;
        this.m_5496_(soundevent, 0.15f, 1.0f);
    }
}

