/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeHooks;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.EntityUtils;
import untamedwilds.world.UntamedWildsGenerator;

public class FaunaSpawn {
    private static boolean isSpawnableSpace(BlockGetter worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn, EntityType<?> entityTypeIn) {
        if (state.m_60838_(worldIn, pos)) {
            return false;
        }
        if (state.m_60803_()) {
            return false;
        }
        if (!fluidStateIn.m_76178_()) {
            return false;
        }
        if (state.m_204336_(BlockTags.f_13054_)) {
            return false;
        }
        return !entityTypeIn.m_20630_(state);
    }

    private static boolean canCreatureTypeSpawnAtLocation(SpawnPlacements.Type placeType, LevelReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        if (placeType == SpawnPlacements.Type.NO_RESTRICTIONS) {
            return true;
        }
        if (entityTypeIn != null && worldIn.m_6857_().m_61937_(pos)) {
            return FaunaSpawn.canSpawnAtBody(placeType, worldIn, pos, entityTypeIn);
        }
        return false;
    }

    private static boolean canSpawnAtBody(SpawnPlacements.Type placeType, LevelReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        BlockState blockstate = worldIn.m_8055_(pos);
        FluidState ifluidstate = worldIn.m_6425_(pos);
        BlockPos blockpos1 = pos.m_7495_();
        switch (placeType) {
            case IN_WATER: {
                return ifluidstate.m_205070_(FluidTags.f_13131_);
            }
            case IN_LAVA: {
                return ifluidstate.m_205070_(FluidTags.f_13132_);
            }
        }
        BlockState blockstate1 = worldIn.m_8055_(blockpos1);
        if (!blockstate1.isValidSpawn(worldIn, blockpos1, placeType, entityTypeIn)) {
            return false;
        }
        return FaunaSpawn.isSpawnableSpace((BlockGetter)worldIn, pos, blockstate, ifluidstate, entityTypeIn);
    }

    public static boolean performWorldGenSpawning(EntityType<?> entityType, SpawnPlacements.Type spawnType, @Nullable Heightmap.Types heightMap, ServerLevelAccessor worldIn, BlockPos pos, Random random, int groupSize) {
        if (((List)ConfigMobControl.dimensionBlacklist.get()).contains(worldIn.m_6018_().m_46472_().m_135782_().toString())) {
            return false;
        }
        if (entityType != null && !worldIn.m_5776_()) {
            int i = pos.m_123341_() + random.nextInt(16);
            int j = pos.m_123343_() + random.nextInt(16);
            if (heightMap != null) {
                pos.m_142082_(i, 0, j);
                pos = worldIn.m_5452_(heightMap, pos);
            }
            if (random.nextFloat() < UntamedWildsGenerator.getBioDiversityLevel(Objects.requireNonNull(((Biome)worldIn.m_204166_(pos).m_203334_()).getRegistryName()))) {
                int k = 1;
                int species = -1;
                block2: for (int packSize = 0; packSize < k; ++packSize) {
                    int x = pos.m_123341_();
                    int y = pos.m_123342_();
                    int z = pos.m_123343_();
                    if (packSize != 0) {
                        x += random.nextInt(6);
                        z += random.nextInt(6);
                    }
                    for (int attempt = 0; attempt < 4; ++attempt) {
                        Mob mobEntity;
                        Entity entity;
                        double d1;
                        if (attempt != 0) {
                            if (attempt == 1) {
                                y += ((Integer)ConfigMobControl.treeSpawnBias.get()).intValue();
                            }
                            x += random.nextInt(2);
                            z += random.nextInt(2);
                        }
                        BlockPos blockpos = new BlockPos(x, y, z);
                        if (!entityType.m_20654_() || !FaunaSpawn.canCreatureTypeSpawnAtLocation(spawnType, (LevelReader)worldIn, blockpos, entityType)) continue;
                        float f = entityType.m_20678_();
                        double d0 = Mth.m_14008_((double)x, (double)((double)blockpos.m_123341_() + (double)f), (double)((double)blockpos.m_123341_() + 16.0 - (double)f));
                        if (!worldIn.m_45772_(entityType.m_20585_(d0, (double)y, d1 = Mth.m_14008_((double)z, (double)((double)blockpos.m_123343_() + (double)f), (double)((double)blockpos.m_123343_() + 16.0 - (double)f)))) || !SpawnPlacements.m_21759_(entityType, (ServerLevelAccessor)worldIn, (MobSpawnType)MobSpawnType.CHUNK_GENERATION, (BlockPos)blockpos, (Random)worldIn.m_5822_())) continue;
                        try {
                            entity = entityType.m_20615_((Level)worldIn.m_6018_());
                        }
                        catch (Exception exception) {
                            UntamedWilds.LOGGER.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        assert (entity != null);
                        entity.m_7678_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), random.nextFloat() * 360.0f, 0.0f);
                        if (!(entity instanceof Mob) || ForgeHooks.canEntitySpawn((Mob)(mobEntity = (Mob)entity), (LevelAccessor)worldIn, (double)d0, (double)blockpos.m_123342_(), (double)d1, null, (MobSpawnType)MobSpawnType.CHUNK_GENERATION) == -1 || !mobEntity.m_5545_((LevelAccessor)worldIn, MobSpawnType.CHUNK_GENERATION) || !worldIn.m_45786_(entity)) continue;
                        mobEntity.m_6518_(worldIn, worldIn.m_6436_(mobEntity.m_142538_()), MobSpawnType.CHUNK_GENERATION, null, null);
                        if (mobEntity instanceof ComplexMob && mobEntity.m_6084_()) {
                            if (mobEntity instanceof ISpecies) {
                                if (species == -1) {
                                    species = ((ComplexMob)mobEntity).getVariant();
                                    if (species != 99) {
                                        k = EntityUtils.getPackSize(entityType, species);
                                    }
                                } else {
                                    ((ComplexMob)mobEntity).setVariant(species);
                                    ((ComplexMob)mobEntity).chooseSkinForSpecies((ComplexMob)mobEntity, false);
                                    if (mobEntity instanceof INeedsPostUpdate) {
                                        ((INeedsPostUpdate)mobEntity).updateAttributes();
                                    }
                                }
                            }
                            if (((ComplexMob)mobEntity).getVariant() == 99 || !ComplexMob.ENTITY_DATA_HASH.containsKey(entityType)) {
                                mobEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                                return false;
                            }
                        }
                        if (!mobEntity.m_6084_()) continue block2;
                        worldIn.m_47205_((Entity)mobEntity);
                        continue block2;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

