/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.BOPNetherBiomes;
import biomesoplenty.common.biome.BOPOverworldBiomes;
import biomesoplenty.common.worldgen.BOPNetherRegionCommon;
import biomesoplenty.common.worldgen.BOPNetherRegionRare;
import biomesoplenty.common.worldgen.BOPOverworldRegionCommon;
import biomesoplenty.common.worldgen.BOPOverworldRegionRare;
import biomesoplenty.common.worldgen.BOPSurfaceRuleData;
import biomesoplenty.init.ModConfig;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static void setup() {
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.overworld());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.nether());
        Regions.register((Region)new BOPOverworldRegionCommon((Integer)ModConfig.GenerationConfig.bopOverworldRegionWeight.get()));
        Regions.register((Region)new BOPOverworldRegionRare((Integer)ModConfig.GenerationConfig.bopOverworldRareRegionWeight.get()));
        Regions.register((Region)new BOPNetherRegionCommon((Integer)ModConfig.GenerationConfig.bopNetherRegionWeight.get()));
        Regions.register((Region)new BOPNetherRegionRare((Integer)ModConfig.GenerationConfig.bopNetherRareRegionWeight.get()));
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerBiome(BOPBiomes.BAMBOO_GROVE, BOPOverworldBiomes.bambooGrove());
        ModBiomes.registerBiome(BOPBiomes.BAYOU, BOPOverworldBiomes.bayou());
        ModBiomes.registerBiome(BOPBiomes.BOG, BOPOverworldBiomes.bog());
        ModBiomes.registerBiome(BOPBiomes.BOREAL_FOREST, BOPOverworldBiomes.borealForest());
        ModBiomes.registerBiome(BOPBiomes.CHERRY_BLOSSOM_GROVE, BOPOverworldBiomes.cherryBlossomGrove());
        ModBiomes.registerBiome(BOPBiomes.CLOVER_PATCH, BOPOverworldBiomes.cloverPatch());
        ModBiomes.registerBiome(BOPBiomes.COLD_DESERT, BOPOverworldBiomes.coldDesert());
        ModBiomes.registerBiome(BOPBiomes.CONIFEROUS_FOREST, BOPOverworldBiomes.coniferousForest(false));
        ModBiomes.registerBiome(BOPBiomes.CRAG, BOPOverworldBiomes.crag());
        ModBiomes.registerBiome(BOPBiomes.DEAD_FOREST, BOPOverworldBiomes.deadForest());
        ModBiomes.registerBiome(BOPBiomes.DRYLAND, BOPOverworldBiomes.dryland());
        ModBiomes.registerBiome(BOPBiomes.DUNE_BEACH, BOPOverworldBiomes.duneBeach());
        ModBiomes.registerBiome(BOPBiomes.FIELD, BOPOverworldBiomes.field(false));
        ModBiomes.registerBiome(BOPBiomes.FIR_CLEARING, BOPOverworldBiomes.firClearing(false));
        ModBiomes.registerBiome(BOPBiomes.FLOODPLAIN, BOPOverworldBiomes.floodplain());
        ModBiomes.registerBiome(BOPBiomes.FORESTED_FIELD, BOPOverworldBiomes.field(true));
        ModBiomes.registerBiome(BOPBiomes.FUNGAL_JUNGLE, BOPOverworldBiomes.fungalJungle());
        ModBiomes.registerBiome(BOPBiomes.GRASSLAND, BOPOverworldBiomes.grassland());
        ModBiomes.registerBiome(BOPBiomes.HIGHLAND, BOPOverworldBiomes.highland(false));
        ModBiomes.registerBiome(BOPBiomes.HIGHLAND_MOOR, BOPOverworldBiomes.highland(true));
        ModBiomes.registerBiome(BOPBiomes.JADE_CLIFFS, BOPOverworldBiomes.jadeCliffs());
        ModBiomes.registerBiome(BOPBiomes.LAVENDER_FIELD, BOPOverworldBiomes.lavenderField(false));
        ModBiomes.registerBiome(BOPBiomes.LAVENDER_FOREST, BOPOverworldBiomes.lavenderField(true));
        ModBiomes.registerBiome(BOPBiomes.LUSH_DESERT, BOPOverworldBiomes.lushDesert());
        ModBiomes.registerBiome(BOPBiomes.LUSH_SAVANNA, BOPOverworldBiomes.lushSavanna());
        ModBiomes.registerBiome(BOPBiomes.MAPLE_WOODS, BOPOverworldBiomes.mapleWoods(false));
        ModBiomes.registerBiome(BOPBiomes.MARSH, BOPOverworldBiomes.marsh());
        ModBiomes.registerBiome(BOPBiomes.MEDITERRANEAN_FOREST, BOPOverworldBiomes.mediterraneanForest());
        ModBiomes.registerBiome(BOPBiomes.MUSKEG, BOPOverworldBiomes.muskeg());
        ModBiomes.registerBiome(BOPBiomes.MYSTIC_GROVE, BOPOverworldBiomes.mysticGrove());
        ModBiomes.registerBiome(BOPBiomes.OLD_GROWTH_DEAD_FOREST, BOPOverworldBiomes.oldGrowthDeadForest());
        ModBiomes.registerBiome(BOPBiomes.OLD_GROWTH_WOODLAND, BOPOverworldBiomes.woodland(true));
        ModBiomes.registerBiome(BOPBiomes.OMINOUS_WOODS, BOPOverworldBiomes.ominousWoods());
        ModBiomes.registerBiome(BOPBiomes.ORCHARD, BOPOverworldBiomes.orchard());
        ModBiomes.registerBiome(BOPBiomes.ORIGIN_VALLEY, BOPOverworldBiomes.originValley());
        ModBiomes.registerBiome(BOPBiomes.PASTURE, BOPOverworldBiomes.pasture());
        ModBiomes.registerBiome(BOPBiomes.PRAIRIE, BOPOverworldBiomes.prairie());
        ModBiomes.registerBiome(BOPBiomes.PUMPKIN_PATCH, BOPOverworldBiomes.pumpkinPatch());
        ModBiomes.registerBiome(BOPBiomes.RAINBOW_HILLS, BOPOverworldBiomes.rainbowHills());
        ModBiomes.registerBiome(BOPBiomes.RAINFOREST, BOPOverworldBiomes.rainforest());
        ModBiomes.registerBiome(BOPBiomes.REDWOOD_FOREST, BOPOverworldBiomes.redwoodForest());
        ModBiomes.registerBiome(BOPBiomes.ROCKY_RAINFOREST, BOPOverworldBiomes.rockyRainforest());
        ModBiomes.registerBiome(BOPBiomes.ROCKY_SHRUBLAND, BOPOverworldBiomes.rockyShrubland());
        ModBiomes.registerBiome(BOPBiomes.SCRUBLAND, BOPOverworldBiomes.scrubland(false));
        ModBiomes.registerBiome(BOPBiomes.SEASONAL_FOREST, BOPOverworldBiomes.seasonalForest());
        ModBiomes.registerBiome(BOPBiomes.SHRUBLAND, BOPOverworldBiomes.shrubland());
        ModBiomes.registerBiome(BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPOverworldBiomes.coniferousForest(true));
        ModBiomes.registerBiome(BOPBiomes.SNOWY_FIR_CLEARING, BOPOverworldBiomes.firClearing(true));
        ModBiomes.registerBiome(BOPBiomes.SNOWY_MAPLE_WOODS, BOPOverworldBiomes.mapleWoods(true));
        ModBiomes.registerBiome(BOPBiomes.TROPICS, BOPOverworldBiomes.tropics());
        ModBiomes.registerBiome(BOPBiomes.TUNDRA, BOPOverworldBiomes.tundra());
        ModBiomes.registerBiome(BOPBiomes.VOLCANIC_PLAINS, BOPOverworldBiomes.volcanicPlains());
        ModBiomes.registerBiome(BOPBiomes.VOLCANO, BOPOverworldBiomes.volcano());
        ModBiomes.registerBiome(BOPBiomes.WASTELAND, BOPOverworldBiomes.wasteland(false));
        ModBiomes.registerBiome(BOPBiomes.WETLAND, BOPOverworldBiomes.wetland());
        ModBiomes.registerBiome(BOPBiomes.WOODED_SCRUBLAND, BOPOverworldBiomes.scrubland(true));
        ModBiomes.registerBiome(BOPBiomes.WOODED_WASTELAND, BOPOverworldBiomes.wasteland(true));
        ModBiomes.registerBiome(BOPBiomes.WOODLAND, BOPOverworldBiomes.woodland(false));
        ModBiomes.registerBiome(BOPBiomes.GLOWING_GROTTO, BOPOverworldBiomes.glowingGrotto());
        ModBiomes.registerBiome(BOPBiomes.SPIDER_NEST, BOPOverworldBiomes.spiderNest());
        ModBiomes.registerBiome(BOPBiomes.CRYSTALLINE_CHASM, BOPNetherBiomes.crystallineChasm());
        ModBiomes.registerBiome(BOPBiomes.ERUPTING_INFERNO, BOPNetherBiomes.eruptingInferno());
        ModBiomes.registerBiome(BOPBiomes.UNDERGROWTH, BOPNetherBiomes.undergrowth());
        ModBiomes.registerBiome(BOPBiomes.VISCERAL_HEAP, BOPNetherBiomes.visceralHeap());
        ModBiomes.registerBiome(BOPBiomes.WITHERED_ABYSS, BOPNetherBiomes.witheredAbyss());
        ModBiomes.registerBiomeDictionaryTags();
        ModBiomes.registerVillagerTypes();
    }

    private static void registerBiomeDictionaryTags() {
        ModBiomes.registerBiomeToDictionary(BOPBiomes.BAMBOO_GROVE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.BAYOU, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.BOG, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.BOREAL_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.CHERRY_BLOSSOM_GROVE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.CLOVER_PATCH, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.COLD_DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.CONIFEROUS_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.CRAG, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.DEAD_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.DRYLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.DUNE_BEACH, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.FIR_CLEARING, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.FIELD, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.FLOODPLAIN, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.FORESTED_FIELD, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.FUNGAL_JUNGLE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.GRASSLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.HIGHLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.HIGHLAND_MOOR, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.JADE_CLIFFS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.LAVENDER_FIELD, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.LAVENDER_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.LUSH_DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.LUSH_SAVANNA, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.MAPLE_WOODS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.MARSH, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.MEDITERRANEAN_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.MUSKEG, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.MYSTIC_GROVE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.OLD_GROWTH_DEAD_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.OLD_GROWTH_WOODLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.OMINOUS_WOODS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ORCHARD, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ORIGIN_VALLEY, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.PASTURE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.PRAIRIE, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.PUMPKIN_PATCH, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.RAINBOW_HILLS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.RAINFOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.REDWOOD_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ROCKY_RAINFOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLATEAU);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ROCKY_SHRUBLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SCRUBLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SEASONAL_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SHRUBLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SNOWY_CONIFEROUS_FOREST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SNOWY_FIR_CLEARING, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SNOWY_MAPLE_WOODS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.TROPICS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.TUNDRA, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.VOLCANIC_PLAINS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.VOLCANO, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.WASTELAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.WETLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.WOODED_SCRUBLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.WOODED_WASTELAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.WASTELAND);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.WOODLAND, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.GLOWING_GROTTO, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.SPIDER_NEST, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SPOOKY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.CRYSTALLINE_CHASM, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.MAGICAL);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ERUPTING_INFERNO, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.UNDERGROWTH, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.VISCERAL_HEAP, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.WITHERED_ABYSS, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.VOID);
    }

    private static void registerVillagerTypes() {
        ModBiomes.registerVillagerType(BOPBiomes.BAMBOO_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.BAYOU, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.BOG, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.BOREAL_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.CHERRY_BLOSSOM_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.CLOVER_PATCH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.COLD_DESERT, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.CONIFEROUS_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.CRAG, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.DEAD_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.DRYLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.DUNE_BEACH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.FIR_CLEARING, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FIELD, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FLOODPLAIN, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.FORESTED_FIELD, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.FUNGAL_JUNGLE, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.GRASSLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.HIGHLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.HIGHLAND_MOOR, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.JADE_CLIFFS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LAVENDER_FIELD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LAVENDER_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.LUSH_DESERT, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.LUSH_SAVANNA, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.MAPLE_WOODS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.MARSH, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.MEDITERRANEAN_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.MUSKEG, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.MYSTIC_GROVE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OLD_GROWTH_DEAD_FOREST, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.OLD_GROWTH_WOODLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.OMINOUS_WOODS, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.ORCHARD, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.ORIGIN_VALLEY, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PASTURE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PRAIRIE, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.PUMPKIN_PATCH, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.RAINBOW_HILLS, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.RAINFOREST, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.ROCKY_RAINFOREST, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.REDWOOD_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.ROCKY_SHRUBLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SCRUBLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.SEASONAL_FOREST, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SHRUBLAND, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_CONIFEROUS_FOREST, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_FIR_CLEARING, VillagerType.f_35823_);
        ModBiomes.registerVillagerType(BOPBiomes.SNOWY_MAPLE_WOODS, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.TROPICS, VillagerType.f_35820_);
        ModBiomes.registerVillagerType(BOPBiomes.TUNDRA, VillagerType.f_35825_);
        ModBiomes.registerVillagerType(BOPBiomes.VOLCANIC_PLAINS, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.VOLCANO, VillagerType.f_35821_);
        ModBiomes.registerVillagerType(BOPBiomes.WASTELAND, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.WETLAND, VillagerType.f_35824_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODED_SCRUBLAND, VillagerType.f_35822_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODED_WASTELAND, VillagerType.f_35819_);
        ModBiomes.registerVillagerType(BOPBiomes.WOODLAND, VillagerType.f_35821_);
    }

    public static void registerBiome(ResourceKey<Biome> key, Biome biome) {
        if (ModConfig.isBiomeEnabled(key)) {
            biome.setRegistryName(key.m_135782_());
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        }
    }

    private static void registerBiomeToDictionary(ResourceKey<Biome> key, BiomeDictionary.Type ... type) {
        if (ModConfig.isBiomeEnabled(key)) {
            BiomeDictionary.addTypes(key, (BiomeDictionary.Type[])type);
        }
    }

    private static void registerVillagerType(ResourceKey<Biome> key, VillagerType type) {
        if (ModConfig.isBiomeEnabled(key)) {
            VillagerType.f_35827_.put(key, type);
        }
    }
}

