/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.desert;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.yungsextras.module.FeatureProcessorModule;
import com.yungnickyoung.minecraft.yungsextras.world.config.DesertWellFeatureConfiguration;
import com.yungnickyoung.minecraft.yungsextras.world.feature.AbstractNbtFeature;
import com.yungnickyoung.minecraft.yungsextras.world.processor.INbtFeatureProcessor;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
public class DesertWellFeature
extends AbstractNbtFeature<DesertWellFeatureConfiguration> {
    public DesertWellFeature() {
        super(DesertWellFeatureConfiguration.CODEC);
    }

    @Override
    protected List<INbtFeatureProcessor> useProcessors() {
        return Lists.newArrayList((Object[])new INbtFeatureProcessor[]{FeatureProcessorModule.DESERT_WELL_PROCESSOR});
    }

    public boolean m_142674_(FeaturePlaceContext<DesertWellFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos pos = context.m_159777_();
        int radius = ((DesertWellFeatureConfiguration)context.m_159778_()).getRadius();
        ResourceLocation location = ((DesertWellFeatureConfiguration)context.m_159778_()).getLocation();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (level.m_46859_((BlockPos)mutable) && mutable.m_123342_() > 7) {
            mutable.m_122173_(Direction.DOWN);
        }
        BlockPos surfacePos = mutable.m_7949_();
        Block block = level.m_8055_(surfacePos).m_60734_();
        if (!block.m_49966_().m_204336_(BlockTags.f_13029_)) {
            return false;
        }
        for (int i = 1; i <= 7; ++i) {
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.NORTH, radius).m_122175_(Direction.EAST, radius);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.EAST, radius).m_122175_(Direction.SOUTH, radius);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.SOUTH, radius).m_122175_(Direction.WEST, radius);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.WEST, radius).m_122175_(Direction.NORTH, radius);
            if (!level.m_46859_((BlockPos)mutable)) continue;
            return false;
        }
        StructureTemplate template = this.createTemplateFromCenter(location, level, rand, surfacePos.m_5484_(Direction.DOWN, 6));
        return template != null;
    }
}

