/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames.events;

import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.JsonFunctions;
import com.natamus.villagernames.config.ConfigHandler;
import com.natamus.villagernames.util.Names;
import java.util.HashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VillagerEvent {
    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent e) {
        Level world = e.getWorld();
        if (world.f_46443_) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Villager)) {
            boolean goname = false;
            if (((Boolean)ConfigHandler.GENERAL.nameModdedVillagers.get()).booleanValue() && EntityFunctions.isModdedVillager((Entity)entity)) {
                goname = true;
            }
            if (!goname) {
                return;
            }
        }
        if (!entity.m_8077_()) {
            EntityFunctions.nameEntity((Entity)entity, (String)Names.getRandomName());
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract e) {
        Level world = e.getWorld();
        if (world.f_46443_) {
            return;
        }
        Entity entity = e.getTarget();
        if (!entity.getClass().equals(Villager.class)) {
            return;
        }
        if (!entity.m_8077_()) {
            return;
        }
        Player player = e.getPlayer();
        if (player.m_6047_()) {
            return;
        }
        final Villager villager = (Villager)entity;
        VillagerData d = villager.m_7141_();
        String profession = d.m_35571_().toString();
        if (profession == "none" || profession == "nitwit") {
            return;
        }
        if (profession.contains(":")) {
            profession = profession.split(":")[1];
        }
        if (profession.contains("-")) {
            profession = profession.split("-")[0].trim();
        }
        Component namecomponent = villager.m_7755_();
        String json = Component.Serializer.m_130703_((Component)namecomponent);
        final HashMap map = JsonFunctions.JsonStringToHashMap((String)json);
        final String prevname = (String)map.get("text");
        final String upperprofession = profession.substring(0, 1).toUpperCase() + profession.substring(1);
        map.put("text", prevname + " the " + upperprofession);
        villager.m_6593_((Component)Component.Serializer.m_130701_((String)JsonFunctions.HashMapToJsonString((HashMap)map)));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                map.put("text", prevname.replace(" the ", "").replace(upperprofession, ""));
                villager.m_6593_((Component)Component.Serializer.m_130701_((String)JsonFunctions.HashMapToJsonString((HashMap)map)));
            }
        }).start();
    }
}

