/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.common.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.common.world.structures.StructureSettings;
import com.stal111.valhelsia_structures.core.init.ModStructureFeatures;
import com.stal111.valhelsia_structures.utils.ConfigurableValue;
import com.stal111.valhelsia_structures.utils.ModTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import org.apache.commons.lang3.mutable.MutableObject;

public class WitchHutStructure
extends AbstractValhelsiaStructure {
    private static final List<MobSpawnSettings.SpawnerData> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 100, 1, 1));
    private static final List<MobSpawnSettings.SpawnerData> CREATURE_SPAWN_LIST = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20553_, 100, 1, 1));

    public WitchHutStructure(Codec<JigsawConfiguration> villageConfigCodec, Predicate<PieceGeneratorSupplier.Context<JigsawConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<JigsawConfiguration>, Optional<PieceGenerator<JigsawConfiguration>>> pieceCreationPredicate) {
        super(villageConfigCodec, "witch_hut", locationCheckPredicate, pieceCreationPredicate, new StructureSettings(ConfigurableValue.of(0.85), ConfigurableValue.of(23), ConfigurableValue.of(6), ModTags.Biomes.HAS_WITCH_HUT, Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146328_(MONSTER_SPAWN_LIST)), MobCategory.CREATURE, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146328_(CREATURE_SPAWN_LIST)))));
    }

    public static WitchHutStructure create(Codec<JigsawConfiguration> codec) {
        MutableObject box = new MutableObject();
        WitchHutStructure finalInstance = new WitchHutStructure(codec, context -> ((WitchHutStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<JigsawConfiguration>)context), context -> ((WitchHutStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<JigsawConfiguration>)context));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    @Override
    public Pair<Integer, Integer> getSize() {
        return Pair.of((Object)13, (Object)12);
    }

    @Override
    public int getSeedModifier() {
        return 70882951;
    }

    @Override
    public Holder<ConfiguredStructureFeature<?, ?>> getStructureFeature() {
        return ModStructureFeatures.WITCH_HUT;
    }

    @Override
    public int getMargin() {
        return 3;
    }

    @Override
    public boolean canGenerateOnWater() {
        return true;
    }
}

