/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core.data.client;

import com.stal111.valhelsia_structures.common.block.BigJarBlock;
import com.stal111.valhelsia_structures.common.block.BigJarTopBlock;
import com.stal111.valhelsia_structures.common.block.BrazierBlock;
import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.JarBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.common.block.ValhelsiaStoneBlock;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import com.stal111.valhelsia_structures.core.init.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.data.ValhelsiaBlockStateProvider;

public class ModBlockStateProvider
extends ValhelsiaBlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, ValhelsiaStructures.REGISTRY_MANAGER, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.getRemainingBlocks().removeIf(block -> this.getName((Block)block.get()).contains("lapidified_jungle_post"));
        this.forEach(block -> block instanceof BrazierBlock, this::brazierBlock);
        this.forEach(block -> block instanceof PostBlock, this::postBlock);
        this.forEach(block -> block instanceof CutPostBlock, this::cutPostBlock);
        this.take(block -> this.paneBlock((IronBarsBlock)block, this.modLoc("block/metal_framed_glass"), this.modLoc("block/metal_framed_glass_pane_top")), new RegistryObject[]{ModBlocks.METAL_FRAMED_GLASS_PANE});
        this.take(block -> this.paneBlock((IronBarsBlock)block, this.modLoc("block/paper_wall"), this.modLoc("block/paper_wall_top")), new RegistryObject[]{ModBlocks.PAPER_WALL});
        this.take(this::hangingVinesBlock, new RegistryObject[]{ModBlocks.HANGING_VINES_BODY, ModBlocks.HANGING_VINES});
        this.forEach(block -> block instanceof JarBlock, this::jarBlock);
        this.forEach(block -> block instanceof BigJarBlock, this::bigJarBlock);
        this.take(block -> this.logBlock((RotatedPillarBlock)block), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_LOG});
        this.take(block -> this.axisBlock((RotatedPillarBlock)block, this.modLoc("block/lapidified_jungle_log"), this.modLoc("block/lapidified_jungle_log")), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_WOOD});
        ResourceLocation lapidifiedJunglePlanks = this.modLoc("block/lapidified_jungle_planks");
        this.take(arg_0 -> ((ModBlockStateProvider)this).simpleBlock(arg_0), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_PLANKS});
        this.take(block -> this.slabBlock((SlabBlock)block, lapidifiedJunglePlanks, lapidifiedJunglePlanks), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_SLAB});
        this.take(block -> this.stairsBlock((StairBlock)block, lapidifiedJunglePlanks), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_STAIRS});
        this.take(block -> this.pressurePlateBlock((Block)block, lapidifiedJunglePlanks), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_PRESSURE_PLATE});
        this.take(block -> this.buttonBlock((ButtonBlock)block, lapidifiedJunglePlanks), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_BUTTON});
        this.take(block -> this.fenceBlock((FenceBlock)block, lapidifiedJunglePlanks), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_FENCE});
        this.take(block -> this.fenceGateBlock((FenceGateBlock)block, lapidifiedJunglePlanks), new RegistryObject[]{ModBlocks.LAPIDIFIED_JUNGLE_FENCE_GATE});
        this.take(arg_0 -> ((ModBlockStateProvider)this).withExistingModel(arg_0), new RegistryObject[]{ModBlocks.HIBISCUS, ModBlocks.GIANT_FERN});
        this.take(block -> this.torchBlock((Block)block, this.modLoc("block/doused_torch")), new RegistryObject[]{ModBlocks.DOUSED_TORCH, ModBlocks.DOUSED_SOUL_TORCH});
        this.take(block -> this.wallTorchBlock((Block)block, this.modLoc("block/doused_torch")), new RegistryObject[]{ModBlocks.DOUSED_WALL_TORCH, ModBlocks.DOUSED_SOUL_WALL_TORCH});
        this.take(this::bonePileBlock, new RegistryObject[]{ModBlocks.BONE_PILE});
        this.forEach(block -> block instanceof ValhelsiaStoneBlock, block -> this.withExistingModel((Block)block, true));
        this.take(this::valhelsiaGrassBlock, new RegistryObject[]{ModBlocks.GRASS_BLOCK});
        this.take(block -> this.simpleBlock((Block)block, (ModelFile)this.models().cubeAll(this.getName((Block)block), this.modLoc("block/dungeon_door"))), new RegistryObject[]{ModBlocks.DUNGEON_DOOR_LEAF});
        this.forEach(block -> block instanceof BigJarTopBlock, block -> this.simpleBlock((Block)block, (ModelFile)this.getExistingModel(this.modLoc("block/big_jar_top"))));
        this.take(block -> this.simpleBlock((Block)block, (ModelFile)this.getExistingModel(this.modLoc("block/explorers_tent"))), new RegistryObject[]{ModBlocks.EXPLORERS_TENT});
        this.forEach(arg_0 -> ((ModBlockStateProvider)this).simpleBlock(arg_0));
    }

    private void brazierBlock(Block block) {
        String name = this.getName(block);
        ModelFile.ExistingModelFile model = this.getExistingModel(this.modLoc("block/" + name));
        ModelFile.ExistingModelFile offModel = this.getExistingModel(this.modLoc("block/" + name + "_off"));
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)offModel).addModel();
    }

    private void postBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/post"))).texture("post_side", this.modLoc("block/post/" + name))).texture("post_end", this.modLoc("block/post/" + name + "_top"));
        ModelBuilder attachedModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("attached_" + name, this.modLoc("block/attached_post"))).texture("post_side", this.modLoc("block/post/" + name))).texture("post_end", this.modLoc("block/post/" + name + "_top"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$postBlock$24((ModelFile)attachedModel, (ModelFile)model, arg_0), new Property[]{PostBlock.WATERLOGGED});
    }

    private void cutPostBlock(Block block) {
        String name = this.getName(block);
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int rotationX;
            Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            int n = facing == Direction.DOWN ? 180 : (rotationX = facing == Direction.UP ? 0 : 90);
            int rotationY = facing == Direction.SOUTH ? 180 : (facing == Direction.WEST ? 270 : (facing == Direction.EAST ? 90 : 0));
            int parts = (Integer)state.m_61143_((Property)ModBlockStateProperties.PARTS_1_4);
            ModelFile.ExistingModelFile model = parts == 4 ? this.getExistingModel(this.modLoc(name.substring(4))) : ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_" + parts, this.modLoc("block/cut_post_" + parts))).texture("post_side", this.modLoc("block/post/" + name.substring(4)))).texture("post_end", this.modLoc("block/post/" + name.substring(4) + "_top"));
            ModelFile.ExistingModelFile attachedModel = parts == 4 ? this.getExistingModel(this.modLoc("attached_" + name.substring(4))) : ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("attached_" + name + "_" + parts, this.modLoc("block/attached_cut_post_" + parts))).texture("post_side", this.modLoc("block/post/" + name.substring(4)))).texture("post_end", this.modLoc("block/post/" + name.substring(4) + "_top"));
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)PostBlock.ATTACHED) != false ? attachedModel : model)).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[]{PostBlock.WATERLOGGED});
    }

    private void hangingVinesBlock(Block block) {
        String name = this.getName(block);
        ModelFile.ExistingModelFile model = this.getExistingModel(this.modLoc("block/" + name));
        ModelFile.ExistingModelFile attachedModel = this.getExistingModel(this.modLoc("block/attached_" + name));
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)ModBlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)attachedModel).addModel()).partialState().with((Property)ModBlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel();
    }

    private void jarBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/jar"))).texture("jar", this.modLoc("block/jar/" + name));
        ModelBuilder rotatedModel = ((BlockModelBuilder)this.models().withExistingParent("rotated_" + name, this.modLoc("block/rotated_jar"))).texture("jar", this.modLoc("block/jar/" + name));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$jarBlock$26((ModelFile)rotatedModel, (ModelFile)model, arg_0), new Property[]{ModBlockStateProperties.TREASURE, BlockStateProperties.f_61362_});
    }

    private void bigJarBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/big_jar"))).texture("jar", this.modLoc("block/jar/big/" + name));
        ModelBuilder rotatedModel = ((BlockModelBuilder)this.models().withExistingParent("rotated_" + name, this.modLoc("block/rotated_big_jar"))).texture("jar", this.modLoc("block/jar/big/" + name));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$bigJarBlock$27((ModelFile)model, (ModelFile)rotatedModel, arg_0), new Property[]{ModBlockStateProperties.TREASURE, BlockStateProperties.f_61362_});
    }

    private void torchBlock(Block block) {
        this.torchBlock(block, this.modLoc("blocks/" + this.getName(block)));
    }

    private void torchBlock(Block block, ResourceLocation texture) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().torch(this.getName(block), texture))});
    }

    private void wallTorchBlock(Block block, ResourceLocation texture) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().torchWall(this.getName(block), texture)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    private void valhelsiaGrassBlock(Block block) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.getExistingModel(this.mcLoc("block/grass_block"))).nextModel().modelFile((ModelFile)this.getExistingModel(this.mcLoc("block/grass_block"))).rotationY(90).nextModel().modelFile((ModelFile)this.getExistingModel(this.mcLoc("block/grass_block"))).rotationY(180).nextModel().modelFile((ModelFile)this.getExistingModel(this.mcLoc("block/grass_block"))).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.getExistingModel(this.mcLoc("block/grass_block_snow"))).addModel();
    }

    private void bonePileBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"))).texture("layer0", this.modLoc("block/" + name));
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)model).rotationX(90).addModel();
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", this.mcLoc("block/pressure_plate_up"))).texture("texture", this.modLoc("block/" + name));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bigJarBlock$27(ModelFile model, ModelFile rotatedModel, BlockState state) {
        int rotation = (Integer)state.m_61143_((Property)ModBlockStateProperties.ROTATION_0_7);
        return ConfiguredModel.builder().modelFile(rotation % 2 == 0 ? model : rotatedModel).rotationY(rotation % 2 == 0 ? rotation * 45 : (rotation - 1) * 45).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$jarBlock$26(ModelFile rotatedModel, ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)ModBlockStateProperties.ROTATED) != false ? rotatedModel : model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$postBlock$24(ModelFile attachedModel, ModelFile model, BlockState state) {
        int rotationX = state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? 0 : 90;
        int rotationY = state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.X ? 90 : 0;
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)PostBlock.ATTACHED) != false ? attachedModel : model).rotationX(rotationX).rotationY(rotationY).build();
    }
}

