/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.common.block.DousedTorchBlock;
import com.stal111.valhelsia_structures.core.init.ModBlocks;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;

public class TorchTransformationHandler {
    private static final Map<Block, DousedTorchBlock> TORCH_TO_DOUSED_TORCH_MAP = new ImmutableMap.Builder().put((Object)Blocks.f_50081_, (Object)((DousedTorchBlock)ModBlocks.DOUSED_TORCH.get())).put((Object)Blocks.f_50082_, (Object)((DousedTorchBlock)ModBlocks.DOUSED_WALL_TORCH.get())).put((Object)Blocks.f_50139_, (Object)((DousedTorchBlock)ModBlocks.DOUSED_SOUL_TORCH.get())).put((Object)Blocks.f_50140_, (Object)((DousedTorchBlock)ModBlocks.DOUSED_SOUL_WALL_TORCH.get())).build();

    public static boolean hasDousedVersion(Block block) {
        return TORCH_TO_DOUSED_TORCH_MAP.containsKey(block);
    }

    public static DousedTorchBlock getDousedTorchFor(Block block) {
        return TORCH_TO_DOUSED_TORCH_MAP.get(block);
    }

    public static TorchBlock getLitVersionFromDoused(Block block) {
        for (Map.Entry<Block, DousedTorchBlock> entry : TORCH_TO_DOUSED_TORCH_MAP.entrySet()) {
            if (entry.getValue() != block) continue;
            return (TorchBlock)entry.getKey();
        }
        return null;
    }
}

