/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.compat;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="ecologics")
public class CompatEventHandler {
    private static final List<String> portedMods = List.of("azalea", "quarkologics", "quarkazalea", "macawsbridgesazalea");

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> e) {
        for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
            if (!portedMods.contains(mapping.key.m_135827_())) continue;
            ResourceLocation remap = new ResourceLocation("ecologics", mapping.key.m_135815_());
            if (ForgeRegistries.BLOCKS.containsKey(remap)) {
                mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(remap)));
                continue;
            }
            mapping.warn();
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> e) {
        for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
            if (!portedMods.contains(mapping.key.m_135827_())) continue;
            ResourceLocation remap = new ResourceLocation("ecologics", mapping.key.m_135815_());
            if (ForgeRegistries.ITEMS.containsKey(remap)) {
                mapping.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(remap)));
                continue;
            }
            mapping.warn();
        }
    }
}

