/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.compat.decorative_blocks;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;
import samebutdifferent.ecologics.compat.decorative_blocks.DBCompatWoodTypes;
import samebutdifferent.ecologics.compat.decorative_blocks.DBSuppliers;
import samebutdifferent.ecologics.compat.decorative_blocks.block.NoBeamBlock;
import samebutdifferent.ecologics.compat.decorative_blocks.block.NoPalisadeBlock;
import samebutdifferent.ecologics.compat.decorative_blocks.block.NoSeatBlock;
import samebutdifferent.ecologics.compat.decorative_blocks.block.NoSupportBlock;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModItems;

public class DBCompat {
    public static final String DB_ID = "decorative_blocks";
    private static final boolean loaded = ModList.get().isLoaded("decorative_blocks");
    public static final RegistryObject<Block> COCONUT_BEAM = DBCompat.registerBeam("coconut_beam", "coconut");
    public static final RegistryObject<Block> COCONUT_SUPPORT = DBCompat.registerSupport("coconut_support", "coconut");
    public static final RegistryObject<Block> COCONUT_PALISADE = DBCompat.registerPalisade("coconut_palisade", "coconut");
    public static final RegistryObject<Block> COCONUT_SEAT = DBCompat.registerSeat("coconut_seat", "coconut");
    public static final RegistryObject<Block> WALNUT_BEAM = DBCompat.registerBeam("walnut_beam", "walnut");
    public static final RegistryObject<Block> WALNUT_SUPPORT = DBCompat.registerSupport("walnut_support", "walnut");
    public static final RegistryObject<Block> WALNUT_PALISADE = DBCompat.registerPalisade("walnut_palisade", "walnut");
    public static final RegistryObject<Block> WALNUT_SEAT = DBCompat.registerSeat("walnut_seat", "walnut");
    public static final RegistryObject<Block> AZALEA_BEAM = DBCompat.registerBeam("azalea_beam", "azalea");
    public static final RegistryObject<Block> AZALEA_SUPPORT = DBCompat.registerSupport("azalea_support", "azalea");
    public static final RegistryObject<Block> AZALEA_PALISADE = DBCompat.registerPalisade("azalea_palisade", "azalea");
    public static final RegistryObject<Block> AZALEA_SEAT = DBCompat.registerSeat("azalea_seat", "azalea");
    public static final RegistryObject<Block> FLOWERING_AZALEA_BEAM = DBCompat.registerBeam("flowering_azalea_beam", "flowering_azalea");
    public static final RegistryObject<Block> FLOWERING_AZALEA_SUPPORT = DBCompat.registerSupport("flowering_azalea_support", "flowering_azalea");
    public static final RegistryObject<Block> FLOWERING_AZALEA_PALISADE = DBCompat.registerPalisade("flowering_azalea_palisade", "flowering_azalea");
    public static final RegistryObject<Block> FLOWERING_AZALEA_SEAT = DBCompat.registerSeat("flowering_azalea_seat", "flowering_azalea");

    private static RegistryObject<Block> registerBeam(String name, String woodType) {
        RegistryObject toReturn = ModBlocks.BLOCKS.register(name, loaded ? DBSuppliers.createBeamBlock(DBCompatWoodTypes.withName(woodType)) : NoBeamBlock::new);
        DBCompat.registerBlockItem(name, (RegistryObject<Block>)toReturn);
        return toReturn;
    }

    private static RegistryObject<Block> registerSupport(String name, String woodType) {
        RegistryObject toReturn = ModBlocks.BLOCKS.register(name, loaded ? DBSuppliers.createSupportBlock(DBCompatWoodTypes.withName(woodType)) : NoSupportBlock::new);
        DBCompat.registerBlockItem(name, (RegistryObject<Block>)toReturn);
        return toReturn;
    }

    private static RegistryObject<Block> registerPalisade(String name, String woodType) {
        RegistryObject toReturn = ModBlocks.BLOCKS.register(name, loaded ? DBSuppliers.createPalisadeBlock(DBCompatWoodTypes.withName(woodType)) : NoPalisadeBlock::new);
        DBCompat.registerBlockItem(name, (RegistryObject<Block>)toReturn);
        return toReturn;
    }

    private static RegistryObject<Block> registerSeat(String name, String woodType) {
        RegistryObject toReturn = ModBlocks.BLOCKS.register(name, loaded ? DBSuppliers.createSeatBlock(DBCompatWoodTypes.withName(woodType)) : NoSeatBlock::new);
        DBCompat.registerBlockItem(name, (RegistryObject<Block>)toReturn);
        return toReturn;
    }

    private static void registerBlockItem(String name, RegistryObject<Block> regObj) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)regObj.get(), loaded ? new Item.Properties().m_41491_(DBSuppliers.DB_TAB.get()) : new Item.Properties()));
    }

    public static void init() {
    }
}

