/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.compat.decorative_blocks;

import lilypuree.decorative_blocks.blocks.types.IWoodType;
import net.minecraft.world.level.block.Block;
import samebutdifferent.ecologics.registry.ModBlocks;

public enum DBCompatWoodTypes implements IWoodType
{
    COCONUT("coconut"),
    WALNUT("walnut"),
    AZALEA("azalea"),
    FLOWERING_AZALEA("flowering_azalea");

    private final String name;

    private DBCompatWoodTypes(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String namespace() {
        return "ecologics";
    }

    public Block getLog() {
        switch (this) {
            case WALNUT: {
                return (Block)ModBlocks.WALNUT_LOG.get();
            }
            case AZALEA: {
                return (Block)ModBlocks.AZALEA_LOG.get();
            }
            case FLOWERING_AZALEA: {
                return (Block)ModBlocks.FLOWERING_AZALEA_LOG.get();
            }
        }
        return (Block)ModBlocks.COCONUT_LOG.get();
    }

    public Block getStrippedLog() {
        switch (this) {
            case WALNUT: {
                return (Block)ModBlocks.STRIPPED_WALNUT_LOG.get();
            }
            case AZALEA: 
            case FLOWERING_AZALEA: {
                return (Block)ModBlocks.STRIPPED_AZALEA_LOG.get();
            }
        }
        return (Block)ModBlocks.STRIPPED_COCONUT_LOG.get();
    }

    public Block getSlab() {
        switch (this) {
            case WALNUT: {
                return (Block)ModBlocks.WALNUT_SLAB.get();
            }
            case AZALEA: {
                return (Block)ModBlocks.AZALEA_SLAB.get();
            }
            case FLOWERING_AZALEA: {
                return (Block)ModBlocks.FLOWERING_AZALEA_SLAB.get();
            }
        }
        return (Block)ModBlocks.COCONUT_SLAB.get();
    }

    public Block getFence() {
        switch (this) {
            case WALNUT: {
                return (Block)ModBlocks.WALNUT_FENCE.get();
            }
            case AZALEA: {
                return (Block)ModBlocks.AZALEA_FENCE.get();
            }
            case FLOWERING_AZALEA: {
                return (Block)ModBlocks.FLOWERING_AZALEA_FENCE.get();
            }
        }
        return (Block)ModBlocks.COCONUT_FENCE.get();
    }

    public Block getPlanks() {
        switch (this) {
            case WALNUT: {
                return (Block)ModBlocks.WALNUT_PLANKS.get();
            }
            case AZALEA: {
                return (Block)ModBlocks.AZALEA_PLANKS.get();
            }
            case FLOWERING_AZALEA: {
                return (Block)ModBlocks.FLOWERING_AZALEA_PLANKS.get();
            }
        }
        return (Block)ModBlocks.COCONUT_PLANKS.get();
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isFlammable() {
        return true;
    }

    public static DBCompatWoodTypes withName(String name) {
        if (name.equalsIgnoreCase("walnut")) {
            return WALNUT;
        }
        if (name.equalsIgnoreCase("azalea")) {
            return AZALEA;
        }
        if (name.equalsIgnoreCase("flowering_azalea")) {
            return FLOWERING_AZALEA;
        }
        return COCONUT;
    }
}

