/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.compat.quark;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public class QuarkFlagRecipeCondition
implements ICondition {
    private final ResourceLocation location;
    private final String flag;

    public QuarkFlagRecipeCondition(ResourceLocation location, String flag) {
        this.location = location;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        if (ModList.get().isLoaded("quark")) {
            JsonObject object = new JsonObject();
            object.addProperty("type", "quark:flag");
            object.addProperty("flag", this.flag);
            return CraftingHelper.getCondition((JsonObject)object).test();
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<QuarkFlagRecipeCondition> {
        private final ResourceLocation location = new ResourceLocation("ecologics", "quark_flag");

        public void write(JsonObject json, QuarkFlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public QuarkFlagRecipeCondition read(JsonObject json) {
            return new QuarkFlagRecipeCondition(this.location, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

