/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.event;

import com.google.common.collect.ImmutableMap;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import samebutdifferent.ecologics.block.AzaleaFlowerBlock;
import samebutdifferent.ecologics.block.CoconutLeavesBlock;
import samebutdifferent.ecologics.block.properties.ModWoodType;
import samebutdifferent.ecologics.entity.Camel;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.entity.Penguin;
import samebutdifferent.ecologics.entity.Squirrel;
import samebutdifferent.ecologics.loot.AddItemModifier;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModPotions;
import samebutdifferent.ecologics.util.ModBrewingRecipe;

@Mod.EventBusSubscriber(modid="ecologics", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WoodType.m_61844_((WoodType)ModWoodType.COCONUT);
            WoodType.m_61844_((WoodType)ModWoodType.WALNUT);
            WoodType.m_61844_((WoodType)ModWoodType.AZALEA);
            WoodType.m_61844_((WoodType)ModWoodType.FLOWERING_AZALEA);
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(Potions.f_43602_, (Item)ModItems.PENGUIN_FEATHER.get(), (Potion)ModPotions.SLIDING.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe((Potion)ModPotions.SLIDING.get(), Items.f_42451_, (Potion)ModPotions.LONG_SLIDING.get()));
            ModEventHandler.registerCompostables();
            AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)ModBlocks.COCONUT_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_COCONUT_LOG.get())).put((Object)((Block)ModBlocks.COCONUT_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_COCONUT_WOOD.get())).put((Object)((Block)ModBlocks.WALNUT_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_WALNUT_LOG.get())).put((Object)((Block)ModBlocks.WALNUT_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_WALNUT_WOOD.get())).put((Object)((Block)ModBlocks.AZALEA_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_LOG.get())).put((Object)((Block)ModBlocks.FLOWERING_AZALEA_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_LOG.get())).put((Object)((Block)ModBlocks.FLOWERING_AZALEA_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_WOOD.get())).put((Object)((Block)ModBlocks.AZALEA_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_WOOD.get())).build();
            ModEventHandler.registerFlammables();
            SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.CAMEL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Camel::checkCamelSpawnRules);
            SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.SQUIRREL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        });
    }

    @SubscribeEvent
    public static void createAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntityTypes.COCONUT_CRAB.get(), CoconutCrab.createAttributes().m_22265_());
        event.put((EntityType)ModEntityTypes.CAMEL.get(), Camel.createAttributes().m_22265_());
        event.put((EntityType)ModEntityTypes.PENGUIN.get(), Penguin.createAttributes().m_22265_());
        event.put((EntityType)ModEntityTypes.SQUIRREL.get(), Squirrel.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new AddItemModifier.Serializer().setRegistryName("ecologics", "add_item"));
    }

    private static void registerCompostables() {
        ModEventHandler.compostibleBlocks(0.3f, (ItemLike)ModItems.COCONUT_SLICE.get());
        ModEventHandler.compostibleBlocks(0.3f, (ItemLike)((SaplingBlock)ModBlocks.COCONUT_HUSK.get()).m_5456_());
        ModEventHandler.compostibleBlocks(0.3f, (ItemLike)((CoconutLeavesBlock)((Object)ModBlocks.COCONUT_LEAVES.get())).m_5456_());
        ModEventHandler.compostibleBlocks(0.3f, (ItemLike)((LeavesBlock)ModBlocks.WALNUT_LEAVES.get()).m_5456_());
        ModEventHandler.compostibleBlocks(0.3f, (ItemLike)((SaplingBlock)ModBlocks.WALNUT_SAPLING.get()).m_5456_());
        ModEventHandler.compostibleBlocks(0.65f, (ItemLike)((AzaleaFlowerBlock)((Object)ModBlocks.AZALEA_FLOWER.get())).m_5456_());
    }

    private static void compostibleBlocks(float chance, ItemLike item) {
        ComposterBlock.f_51914_.put((Object)item.m_5456_(), chance);
    }

    public static void registerFlammables() {
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_PLANKS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_SLAB.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_FENCE_GATE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_FENCE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_STAIRS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.STRIPPED_COCONUT_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.STRIPPED_COCONUT_WOOD.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_WOOD.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.COCONUT_LEAVES.get(), 30, 60);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_PLANKS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_SLAB.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_FENCE_GATE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_FENCE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_STAIRS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.STRIPPED_WALNUT_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.STRIPPED_WALNUT_WOOD.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_WOOD.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.WALNUT_LEAVES.get(), 30, 60);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_PLANKS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_SLAB.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_FENCE_GATE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_FENCE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_STAIRS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.STRIPPED_AZALEA_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.STRIPPED_AZALEA_WOOD.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.AZALEA_WOOD.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_PLANKS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_SLAB.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_FENCE_GATE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_FENCE.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_STAIRS.get(), 5, 20);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_LOG.get(), 5, 5);
        ModEventHandler.flammableBlock((Block)ModBlocks.FLOWERING_AZALEA_WOOD.get(), 5, 5);
    }

    public static void flammableBlock(Block block, int flameOdds, int burnOdds) {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_(block, flameOdds, burnOdds);
    }
}

