/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContentClasspathLoader;
import vazkii.patchouli.client.book.BookContentExternalLoader;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.client.book.BookContentResourceDirectLoader;
import vazkii.patchouli.client.book.BookContentResourceListenerLoader;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookContentsBuilder {
    public static final String DEFAULT_LANG = "en_us";
    private final Map<ResourceLocation, BookCategory> categories = new HashMap<ResourceLocation, BookCategory>();
    private final Map<ResourceLocation, BookEntry> entries = new HashMap<ResourceLocation, BookEntry>();
    private final Map<ResourceLocation, Supplier<BookTemplate>> templates = new HashMap<ResourceLocation, Supplier<BookTemplate>>();
    private final Map<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>> recipeMappings = new HashMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>>();
    private final boolean singleBookReload;

    public BookContentsBuilder(boolean singleBookReload) {
        this.singleBookReload = singleBookReload;
        this.templates.putAll(BookContents.addonTemplates);
    }

    public BookContentsBuilder() {
        this(false);
    }

    @Nullable
    public BookCategory getCategory(ResourceLocation id) {
        return this.categories.get(id);
    }

    @Nullable
    public BookEntry getEntry(ResourceLocation id) {
        return this.entries.get(id);
    }

    @Nullable
    public Supplier<BookTemplate> getTemplate(ResourceLocation id) {
        return this.templates.get(id);
    }

    public void addRecipeMapping(ItemStackUtil.StackWrapper stack, BookEntry entry, int spread) {
        this.recipeMappings.put(stack, (Pair<BookEntry, Integer>)Pair.of((Object)entry, (Object)spread));
    }

    public void loadFrom(Book book) {
        this.load(book, "categories", BookContentsBuilder::loadCategory, this.categories);
        this.load(book, "entries", (b, l, id, file) -> BookContentsBuilder.loadEntry(b, l, id, file, this.categories::get), this.entries);
        this.load(book, "templates", BookContentsBuilder::loadTemplate, this.templates);
    }

    public BookContents build(Book book) {
        this.categories.forEach((id, category) -> {
            try {
                category.build((ResourceLocation)id, this);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while building category " + id, e);
            }
        });
        this.entries.values().forEach(entry -> {
            try {
                entry.build(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Error building entry " + entry.getId(), e);
            }
        });
        BookCategory pamphletCategory = null;
        if (book.isPamphlet) {
            if (this.categories.size() != 1) {
                throw new RuntimeException("A pamphlet should have exactly one category but instead there were " + this.categories.size());
            }
            pamphletCategory = this.categories.values().iterator().next();
        }
        return new BookContents(book, (ImmutableMap<ResourceLocation, BookCategory>)ImmutableMap.copyOf(this.categories), (ImmutableMap<ResourceLocation, BookEntry>)ImmutableMap.copyOf(this.entries), (ImmutableMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>>)ImmutableMap.copyOf(this.recipeMappings), pamphletCategory);
    }

    private <T> void load(Book book, String thing, LoadFunc<T> loader, Map<ResourceLocation, T> builder) {
        BookContentLoader contentLoader = this.getContentLoader(book);
        ArrayList<ResourceLocation> foundIds = new ArrayList<ResourceLocation>();
        contentLoader.findFiles(book, thing, foundIds);
        for (ResourceLocation id : foundIds) {
            String filePath = String.format("%s/%s/%s/%s/%s.json", "patchouli_books", book.id.m_135815_(), DEFAULT_LANG, thing, id.m_135815_());
            T value = loader.load(book, contentLoader, id, new ResourceLocation(id.m_135827_(), filePath));
            if (value == null) continue;
            builder.put(id, value);
        }
    }

    protected BookContentLoader getContentLoader(Book book) {
        if (book.isExternal) {
            return BookContentExternalLoader.INSTANCE;
        }
        if (book.useResourcePack) {
            return this.singleBookReload ? BookContentResourceDirectLoader.INSTANCE : BookContentResourceListenerLoader.INSTANCE;
        }
        return BookContentClasspathLoader.INSTANCE;
    }

    @Nullable
    private static BookCategory loadCategory(Book book, BookContentLoader loader, ResourceLocation id, ResourceLocation file) {
        JsonElement json = BookContentsBuilder.loadLocalizedJson(book, loader, file);
        BookCategory category = (BookCategory)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookCategory.class);
        if (category == null) {
            throw new IllegalArgumentException(file + " does not exist.");
        }
        category.setBook(book);
        if (category.canAdd()) {
            return category;
        }
        return null;
    }

    @Nullable
    private static BookEntry loadEntry(Book book, BookContentLoader loader, ResourceLocation id, ResourceLocation file, Function<ResourceLocation, BookCategory> categories) {
        JsonElement json = BookContentsBuilder.loadLocalizedJson(book, loader, file);
        BookEntry entry = (BookEntry)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookEntry.class);
        if (entry == null) {
            throw new IllegalArgumentException(file + " does not exist.");
        }
        entry.setBook(book);
        if (entry.canAdd()) {
            entry.initCategory(categories);
            BookCategory category = entry.getCategory();
            if (category == null) {
                String msg = String.format("Entry in file %s does not have a valid category.", file);
                throw new RuntimeException(msg);
            }
            category.addEntry(entry);
            entry.setId(id);
            return entry;
        }
        return null;
    }

    private static Supplier<BookTemplate> loadTemplate(Book book, BookContentLoader loader, ResourceLocation key, ResourceLocation res) {
        JsonElement json = BookContentsBuilder.loadLocalizedJson(book, loader, res);
        Supplier<BookTemplate> supplier = () -> (BookTemplate)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookTemplate.class);
        BookTemplate template = supplier.get();
        if (template == null) {
            throw new IllegalArgumentException(res + " could not be instantiated by the supplier.");
        }
        return supplier;
    }

    private static JsonElement loadLocalizedJson(Book book, BookContentLoader loader, ResourceLocation res) {
        ResourceLocation localized = new ResourceLocation(res.m_135827_(), res.m_135815_().replaceAll(DEFAULT_LANG, ClientBookRegistry.INSTANCE.currentLang));
        JsonElement input = loader.loadJson(book, localized, res);
        if (input == null) {
            throw new IllegalArgumentException(res + " does not exist.");
        }
        return input;
    }

    private static interface LoadFunc<T> {
        @Nullable
        public T load(Book var1, BookContentLoader var2, ResourceLocation var3, ResourceLocation var4);
    }
}

