/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block;

import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;
import vazkii.quark.api.IEnchantmentInfluencer;
import vazkii.quark.api.IModifiableEnchantmentInfluencer;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;

public class MatrixEnchantingTableBlock
extends EnchantmentTableBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public MatrixEnchantingTableBlock(QuarkModule module) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50201_));
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)"matrix_enchanter");
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
    }

    @Nonnull
    public MutableComponent m_49954_() {
        return Blocks.f_50201_.m_49954_();
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public MatrixEnchantingTableBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new MatrixEnchantingTableBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return MatrixEnchantingTableBlock.m_152132_(type, MatrixEnchantingModule.blockEntityType, MatrixEnchantingTableBlockEntity::tick);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult raytrace) {
        if (!(worldIn.m_7702_(pos) instanceof MatrixEnchantingTableBlockEntity)) {
            worldIn.m_151523_(this.m_142194_(pos, state));
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(MatrixEnchantingModule.class)) {
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MatrixEnchantingTableBlockEntity)worldIn.m_7702_(pos)), (BlockPos)pos);
            }
        } else {
            worldIn.m_46597_(pos, Blocks.f_50201_.m_49966_());
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@Nonnull BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        boolean enabled = ModuleLoader.INSTANCE.isModuleEnabled(MatrixEnchantingModule.class);
        boolean showInfluences = enabled && MatrixEnchantingModule.allowInfluencing;
        boolean allowUnderwater = enabled && MatrixEnchantingModule.allowUnderwaterEnchanting;
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    DyeColor color;
                    IEnchantmentInfluencer influencer;
                    BlockPos blockpos = pos.m_142082_(i, k, j);
                    BlockState state = worldIn.m_8055_(blockpos);
                    BlockPos test = pos.m_142082_(i / 2, 0, j / 2);
                    if (!worldIn.m_46859_(test) && (!allowUnderwater || worldIn.m_8055_(test).m_60734_() != Blocks.f_49990_)) continue block1;
                    if (showInfluences && (influencer = MatrixEnchantingTableBlockEntity.getInfluencerFromBlock(state.m_60734_())) != null && (color = influencer.getEnchantmentInfluenceColor((BlockGetter)worldIn, blockpos, state)) != null) {
                        float[] comp = color.m_41068_();
                        if (influencer instanceof IModifiableEnchantmentInfluencer) {
                            IModifiableEnchantmentInfluencer modifiableInfluencer = (IModifiableEnchantmentInfluencer)influencer;
                            comp = modifiableInfluencer.getModifiedColorComponents((BlockGetter)worldIn, blockpos, state, comp);
                        }
                        int steps = 20;
                        double dx = (double)(pos.m_123341_() - blockpos.m_123341_()) / (double)steps;
                        double dy = (double)(pos.m_123342_() - blockpos.m_123342_()) / (double)steps;
                        double dz = (double)(pos.m_123343_() - blockpos.m_123343_()) / (double)steps;
                        for (int p = 0; p < steps; ++p) {
                            if (rand.nextDouble() < 0.5) continue;
                            double px = (double)blockpos.m_123341_() + 0.5 + dx * (double)p + rand.nextDouble() * 0.2 - 0.1;
                            double py = (double)blockpos.m_123342_() + 0.5 + dy * (double)p + Math.sin((double)p / (double)steps * Math.PI) * 0.5 + rand.nextDouble() * 0.2 - 0.1;
                            double pz = (double)blockpos.m_123343_() + 0.5 + dz * (double)p + rand.nextDouble() * 0.2 - 0.1;
                            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(comp[0], comp[1], comp[2]), 1.0f), px, py, pz, 0.0, 0.0, 0.0);
                        }
                    }
                    if (!(state.getEnchantPowerBonus((LevelReader)worldIn, blockpos) > 0.0f)) continue;
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat()) - 1.0, (double)((float)j + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public void m_6402_(@Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity tileentity;
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof MatrixEnchantingTableBlockEntity) {
            ((MatrixEnchantingTableBlockEntity)tileentity).setCustomName(stack.m_41786_());
        }
    }

    public void m_6810_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof MatrixEnchantingTableBlockEntity) {
            MatrixEnchantingTableBlockEntity enchanter = (MatrixEnchantingTableBlockEntity)tileentity;
            enchanter.dropItem(0);
            enchanter.dropItem(1);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

