/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.capability;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.base.handler.SortingHandler;

public class CrateItemHandler
extends ItemStackHandler {
    private boolean needsUpdate = false;
    private final int maxItems = CrateModule.maxItems;
    public int displayTotal = 0;
    public int displaySlots = 0;

    public CrateItemHandler() {
        super(CrateModule.maxItems);
    }

    private int getTotal() {
        int items = 0;
        for (ItemStack stack : this.stacks) {
            items += stack.m_41613_();
        }
        return items;
    }

    public void recalculate() {
        if (!this.needsUpdate) {
            return;
        }
        this.needsUpdate = false;
        this.displayTotal = 0;
        this.displaySlots = 0;
        NonNullList newStacks = NonNullList.m_122780_((int)this.maxItems, (Object)ItemStack.f_41583_);
        int idx = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            newStacks.set(idx, (Object)stack);
            this.displayTotal += stack.m_41613_();
            ++this.displaySlots;
            ++idx;
        }
        this.stacks = newStacks;
    }

    public void clear() {
        this.needsUpdate = false;
        this.stacks = NonNullList.m_122780_((int)this.maxItems, (Object)ItemStack.f_41583_);
        this.displayTotal = 0;
        this.displaySlots = 0;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void spill(Level level, BlockPos worldPosition) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        SortingHandler.mergeStacks(stacks);
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)worldPosition.m_123341_(), (double)worldPosition.m_123342_(), (double)worldPosition.m_123343_(), (ItemStack)stack);
        }
    }

    public int getSlotLimit(int slot) {
        int total = this.getTotal();
        return Mth.m_14045_((int)(this.maxItems - total), (int)0, (int)64);
    }

    public void onContentsChanged(int slot) {
        this.needsUpdate = true;
    }

    protected void onLoad() {
        this.needsUpdate = true;
        this.recalculate();
    }

    public CompoundTag serializeNBT() {
        ListTag items = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            items.add((Object)stack.m_41739_(new CompoundTag()));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("stacks", (Tag)items);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stacks = NonNullList.m_122780_((int)this.maxItems, (Object)ItemStack.f_41583_);
        ListTag items = nbt.m_128437_("stacks", 10);
        for (int i = 0; i < items.size(); ++i) {
            this.stacks.set(i, (Object)ItemStack.m_41712_((CompoundTag)items.m_128728_(i)));
        }
        this.onLoad();
    }
}

