/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.inventory;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import vazkii.quark.addons.oddities.block.be.CrateBlockEntity;
import vazkii.quark.addons.oddities.capability.CrateItemHandler;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.oddities.ScrollCrateMessage;

public class CrateMenu
extends AbstractContainerMenu {
    public final CrateBlockEntity crate;
    public final Inventory playerInv;
    public static final int numRows = 6;
    public static final int numCols = 9;
    public static final int displayedSlots = 54;
    public final int totalSlots;
    public int scroll = 0;
    private final ContainerData crateData;

    public CrateMenu(int id, Inventory inv, CrateBlockEntity crate) {
        this(id, inv, crate, (ContainerData)new SimpleContainerData(2));
    }

    public CrateMenu(int id, Inventory inv, CrateBlockEntity crate, ContainerData data) {
        super(CrateModule.menuType, id);
        crate.m_5856_(inv.f_35978_);
        this.crate = crate;
        this.playerInv = inv;
        this.crateData = data;
        int i = 36;
        CrateItemHandler handler = crate.itemHandler();
        this.totalSlots = handler.getSlots();
        for (int j = 0; j < this.totalSlots; ++j) {
            this.m_38897_((Slot)new CrateSlot((IItemHandler)handler, j, 8 + j % 9 * 18, 18 + j / 9 * 18));
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inv, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inv, i1, 8 + i1 * 18, 161 + i));
        }
        this.m_38884_(this.crateData);
    }

    public int getTotal() {
        return this.crateData.m_6413_(0);
    }

    public int getStackCount() {
        return this.crateData.m_6413_(1);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack activeStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            activeStack = stackInSlot.m_41777_();
            if (index < this.totalSlots ? !this.m_38903_(stackInSlot, this.totalSlots, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, this.totalSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (!stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return activeStack;
    }

    public static CrateMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        CrateBlockEntity te = (CrateBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(pos);
        return new CrateMenu(windowId, playerInventory, te);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return this.crate.m_6542_(playerIn);
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.crate.m_5785_(playerIn);
    }

    public void scroll(boolean down, boolean packet) {
        boolean did = false;
        if (down) {
            int target = this.scroll + 9;
            int maxScroll = this.getStackCount() / 9 * 9;
            if (target <= maxScroll) {
                this.scroll = target;
                did = true;
                for (Slot slot : this.f_38839_) {
                    if (!(slot instanceof CrateSlot)) continue;
                    slot.f_40221_ -= 18;
                }
            }
        } else {
            int target = this.scroll - 9;
            if (target >= 0) {
                this.scroll = target;
                did = true;
                for (Slot slot : this.f_38839_) {
                    if (!(slot instanceof CrateSlot)) continue;
                    slot.f_40221_ += 18;
                }
            }
        }
        if (did) {
            this.m_38946_();
            if (packet) {
                QuarkNetwork.sendToServer(new ScrollCrateMessage(down));
            }
        }
    }

    private class CrateSlot
    extends SlotItemHandler {
        public CrateSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void m_6654_() {
            CrateMenu.this.crate.itemHandler().onContentsChanged(this.getSlotIndex());
        }

        public boolean m_6659_() {
            int index = this.getSlotIndex();
            return index >= CrateMenu.this.scroll && index < CrateMenu.this.scroll + 54;
        }
    }
}

