/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.screen.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.screen.CategoryScreen;
import vazkii.quark.base.client.config.screen.widgets.IWidgetProvider;
import vazkii.quark.base.client.config.screen.widgets.ScrollableWidgetList;
import vazkii.quark.base.client.handler.TopLayerTooltipHandler;

public class ConfigElementList<T extends IConfigElement & IWidgetProvider>
extends ScrollableWidgetList<CategoryScreen, Entry<T>> {
    public ConfigElementList(CategoryScreen parent) {
        super(parent);
    }

    @Override
    protected void findEntries() {
        boolean hadObjects = false;
        boolean isObject = true;
        for (IConfigElement elm : ((CategoryScreen)this.parent).category.getSubElements()) {
            boolean wasObject = isObject;
            isObject = elm instanceof IConfigObject;
            if (wasObject && !isObject && hadObjects) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry<Object>((CategoryScreen)this.parent, null));
            }
            Entry<IConfigElement> entry = new Entry<IConfigElement>((CategoryScreen)this.parent, elm);
            this.m_7085_((AbstractSelectionList.Entry)entry);
            hadObjects = hadObjects || isObject;
        }
    }

    public static final class Entry<T extends IConfigElement & IWidgetProvider>
    extends ScrollableWidgetList.Entry<Entry<T>> {
        private final T element;

        public Entry(CategoryScreen parent, T element) {
            this.element = element;
            if (element != null) {
                ((IWidgetProvider)element).addWidgets(parent, (IConfigElement)element, this.children);
            }
        }

        @Override
        public void m_6311_(@Nonnull PoseStack mstack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(mstack, index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, partialTicks);
            Minecraft mc = Minecraft.m_91087_();
            if (this.element != null) {
                int left = rowLeft + 10;
                int top = rowTop + 4;
                int effIndex = index + 1;
                if (this.element instanceof ConfigCategory) {
                    --effIndex;
                }
                this.drawBackground(mstack, effIndex, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered);
                Object name = this.element.getGuiDisplayName();
                if (this.element.isDirty()) {
                    name = (String)name + ChatFormatting.GOLD + "*";
                }
                int len = mc.f_91062_.m_92895_((String)name);
                int maxLen = rowWidth - 85;
                Object originalName = null;
                if (len > maxLen) {
                    originalName = name;
                    while ((len = mc.f_91062_.m_92895_((String)(name = ((String)name).substring(0, ((String)name).length() - 1)))) > maxLen) {
                    }
                    name = (String)name + "...";
                }
                List<String> tooltip = this.element.getTooltip();
                if (originalName != null) {
                    if (tooltip == null) {
                        tooltip = new LinkedList<String>();
                        tooltip.add((String)originalName);
                    } else {
                        tooltip.add(0, "");
                        tooltip.add(0, (String)originalName);
                    }
                }
                if (tooltip != null) {
                    int hoverLeft = left + mc.f_91062_.m_92895_((String)name + " ");
                    int hoverRight = hoverLeft + mc.f_91062_.m_92895_("(?)");
                    name = (String)name + ChatFormatting.AQUA + " (?)";
                    if (mouseX >= hoverLeft && mouseX < hoverRight && mouseY >= top && mouseY < top + 10) {
                        TopLayerTooltipHandler.setTooltip(tooltip, mouseX, mouseY);
                    }
                }
                mc.f_91062_.m_92750_(mstack, (String)name, (float)left, (float)top, 0xFFFFFF);
                mc.f_91062_.m_92750_(mstack, ((IWidgetProvider)this.element).getSubtitle(), (float)left, (float)(top + 10), 0x999999);
            } else {
                String s = I18n.m_118938_((String)"quark.gui.config.subcategories", (Object[])new Object[0]);
                mc.f_91062_.m_92750_(mstack, s, (float)rowLeft + (float)(rowWidth / 2 - mc.f_91062_.m_92895_(s) / 2), (float)(rowTop + 7), 0x6666FF);
            }
        }

        @Nonnull
        public Component m_142172_() {
            return new TextComponent(this.element == null ? "" : this.element.getGuiDisplayName());
        }
    }
}

