/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.addons.oddities.client.model.BackpackModel;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.render.QuarkArmorModel;
import vazkii.quark.content.mobs.client.model.CrabModel;
import vazkii.quark.content.mobs.client.model.ForgottenHatModel;
import vazkii.quark.content.mobs.client.model.FoxhoundModel;
import vazkii.quark.content.mobs.client.model.FrogModel;
import vazkii.quark.content.mobs.client.model.ShibaModel;
import vazkii.quark.content.mobs.client.model.StonelingModel;
import vazkii.quark.content.mobs.client.model.ToretoiseModel;
import vazkii.quark.content.mobs.client.model.WraithModel;

@Mod.EventBusSubscriber(modid="quark", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ModelHandler {
    private static final Map<ModelLayerLocation, Layer> layers = new HashMap<ModelLayerLocation, Layer>();
    private static final Map<Pair<ModelLayerLocation, EquipmentSlot>, QuarkArmorModel> cachedArmors = new HashMap<Pair<ModelLayerLocation, EquipmentSlot>, QuarkArmorModel>();
    public static ModelLayerLocation shiba;
    public static ModelLayerLocation foxhound;
    public static ModelLayerLocation stoneling;
    public static ModelLayerLocation crab;
    public static ModelLayerLocation frog;
    public static ModelLayerLocation toretoise;
    public static ModelLayerLocation wraith;
    public static ModelLayerLocation quark_boat;
    public static ModelLayerLocation forgotten_hat;
    public static ModelLayerLocation backpack;
    private static boolean modelsInitted;

    private static void initModels() {
        if (modelsInitted) {
            return;
        }
        shiba = ModelHandler.addModel("shiba", ShibaModel::createBodyLayer, ShibaModel::new);
        foxhound = ModelHandler.addModel("foxhound", FoxhoundModel::createBodyLayer, FoxhoundModel::new);
        stoneling = ModelHandler.addModel("stoneling", StonelingModel::createBodyLayer, StonelingModel::new);
        crab = ModelHandler.addModel("crab", CrabModel::createBodyLayer, CrabModel::new);
        frog = ModelHandler.addModel("frog", FrogModel::createBodyLayer, FrogModel::new);
        toretoise = ModelHandler.addModel("toretoise", ToretoiseModel::createBodyLayer, ToretoiseModel::new);
        wraith = ModelHandler.addModel("wraith", WraithModel::createBodyLayer, WraithModel::new);
        quark_boat = ModelHandler.addModel("quark_boat", BoatModel::m_170463_, BoatModel::new);
        forgotten_hat = ModelHandler.addArmorModel("forgotten_hat", ForgottenHatModel::createBodyLayer);
        backpack = ModelHandler.addArmorModel("backpack", BackpackModel::createBodyLayer);
        modelsInitted = true;
    }

    private static ModelLayerLocation addModel(String name, Supplier<LayerDefinition> supplier, Function<ModelPart, EntityModel<?>> modelConstructor) {
        return ModelHandler.addLayer(name, new Layer(supplier, modelConstructor));
    }

    private static ModelLayerLocation addArmorModel(String name, Supplier<LayerDefinition> supplier) {
        return ModelHandler.addLayer(name, new Layer(supplier, QuarkArmorModel::new));
    }

    private static ModelLayerLocation addLayer(String name, Layer layer) {
        ModelLayerLocation loc = new ModelLayerLocation(new ResourceLocation("quark", name), "main");
        layers.put(loc, layer);
        return loc;
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModelHandler.initModels();
        for (ModelLayerLocation location : layers.keySet()) {
            Quark.LOG.info("Registering model layer " + location);
            event.registerLayerDefinition(location, ModelHandler.layers.get((Object)location).definition);
        }
    }

    public static <T extends Mob, M extends EntityModel<T>> M model(ModelLayerLocation location) {
        ModelHandler.initModels();
        Layer layer = layers.get(location);
        Minecraft mc = Minecraft.m_91087_();
        return (M)layer.modelConstructor.apply(mc.m_167973_().m_171103_(location));
    }

    public static QuarkArmorModel armorModel(ModelLayerLocation location, EquipmentSlot slot) {
        Pair key = Pair.of((Object)location, (Object)slot);
        if (cachedArmors.containsKey(key)) {
            return cachedArmors.get(key);
        }
        ModelHandler.initModels();
        Layer layer = layers.get(location);
        Minecraft mc = Minecraft.m_91087_();
        QuarkArmorModel model = layer.armorModelConstructor.apply(mc.m_167973_().m_171103_(location), slot);
        cachedArmors.put((Pair<ModelLayerLocation, EquipmentSlot>)key, model);
        return model;
    }

    static {
        modelsInitted = false;
    }

    private static class Layer {
        final Supplier<LayerDefinition> definition;
        final Function<ModelPart, EntityModel<?>> modelConstructor;
        final BiFunction<ModelPart, EquipmentSlot, QuarkArmorModel> armorModelConstructor;

        public Layer(Supplier<LayerDefinition> definition, Function<ModelPart, EntityModel<?>> modelConstructor) {
            this.definition = definition;
            this.modelConstructor = modelConstructor;
            this.armorModelConstructor = null;
        }

        public Layer(Supplier<LayerDefinition> definition, BiFunction<ModelPart, EquipmentSlot, QuarkArmorModel> armorModelConstructor) {
            this.definition = definition;
            this.modelConstructor = null;
            this.armorModelConstructor = armorModelConstructor;
        }
    }
}

