/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.item.boat;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.item.boat.QuarkBoat;
import vazkii.quark.base.module.QuarkModule;

public class QuarkBoatItem
extends QuarkItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    public final String type;

    public QuarkBoatItem(String type, QuarkModule module) {
        super(type + "_boat", module, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_));
        this.type = type;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult hitresult = QuarkBoatItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 view = player.m_20252_(1.0f);
        List list = world.m_6249_((Entity)player, player.m_142469_().m_82369_(view.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyes = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(eyes)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            QuarkBoat boat = new QuarkBoat(world, hitresult.m_82450_().f_82479_, hitresult.m_82450_().f_82480_, hitresult.m_82450_().f_82481_);
            boat.setQuarkBoatType(this.type);
            boat.m_146922_(player.m_146908_());
            if (!world.m_45756_((Entity)boat, boat.m_142469_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!world.f_46443_) {
                world.m_7967_((Entity)boat);
                world.m_142346_((Entity)player, GameEvent.f_157810_, new BlockPos(hitresult.m_82450_()));
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }
}

