/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.ModuleFinder;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigResolver;

public final class ModuleLoader {
    public static final ModuleLoader INSTANCE = new ModuleLoader();
    private Map<Class<? extends QuarkModule>, QuarkModule> foundModules = new HashMap<Class<? extends QuarkModule>, QuarkModule>();
    private final List<Step> stepsHandled = new ArrayList<Step>();
    private ConfigResolver config;
    private Runnable onConfigReloadJEI;
    private boolean clientTicked = false;
    private ParallelDispatchEvent event;

    private ModuleLoader() {
    }

    public void start() {
        this.findModules();
        this.dispatch(Step.CONSTRUCT, QuarkModule::construct);
        this.resolveConfigSpec();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        this.dispatch(Step.CONSTRUCT_CLIENT, QuarkModule::constructClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void findModules() {
        ModuleFinder finder = new ModuleFinder();
        finder.findModules();
        this.foundModules = finder.getFoundModules();
    }

    private void resolveConfigSpec() {
        this.config = new ConfigResolver();
        this.config.makeSpec();
    }

    public void register() {
        this.dispatch(Step.REGISTER, QuarkModule::register);
        this.dispatch(Step.POST_REGISTER, QuarkModule::postRegister);
        this.config.registerConfigBoundElements();
    }

    public void configChanged() {
        if (!this.stepsHandled.contains((Object)Step.POST_REGISTER)) {
            return;
        }
        if (this.onConfigReloadJEI != null) {
            this.onConfigReloadJEI.run();
        }
        this.config.configChanged();
        this.dispatch(Step.CONFIG_CHANGED, QuarkModule::configChanged);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
        if (!this.stepsHandled.contains((Object)Step.POST_REGISTER)) {
            return;
        }
        this.dispatch(Step.CONFIG_CHANGED_CLIENT, QuarkModule::configChangedClient);
    }

    public void setup(ParallelDispatchEvent event) {
        this.event = event;
        Quark.proxy.handleQuarkConfigChange();
        this.dispatch(Step.SETUP, QuarkModule::setup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(Step.SETUP_CLIENT, QuarkModule::clientSetup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
        this.dispatch(Step.MODEL_REGISTRY, QuarkModule::modelRegistry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelBake(ModelBakeEvent event) {
        this.dispatch(Step.MODEL_BAKE, m -> m.modelBake(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelLayers(EntityRenderersEvent.AddLayers event) {
        this.dispatch(Step.MODEL_LAYERS, m -> m.modelLayers(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.dispatch(Step.TEXTURE_STITCH, m -> m.textureStitch(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureStitchEvent.Post event) {
        this.dispatch(Step.POST_TEXTURE_STITCH, m -> m.postTextureStitch(event));
    }

    public void loadComplete(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(Step.LOAD_COMPLETE, QuarkModule::loadComplete);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void firstClientTick(TickEvent.ClientTickEvent event) {
        if (!this.clientTicked && event.phase == TickEvent.Phase.END) {
            this.dispatch(Step.FIRST_CLIENT_TICK, QuarkModule::firstClientTick);
            this.clientTicked = true;
        }
    }

    private void dispatch(Step step, Consumer<QuarkModule> run) {
        Quark.LOG.info("Dispatching Module Step " + step);
        this.foundModules.values().forEach(run);
        this.stepsHandled.add(step);
    }

    void enqueue(Runnable r) {
        Preconditions.checkNotNull((Object)this.event);
        this.event.enqueueWork(r);
    }

    public boolean isModuleEnabled(Class<? extends QuarkModule> moduleClazz) {
        QuarkModule module = this.getModuleInstance(moduleClazz);
        return module != null && module.enabled;
    }

    public boolean isModuleEnabledOrOverlapping(Class<? extends QuarkModule> moduleClazz) {
        QuarkModule module = this.getModuleInstance(moduleClazz);
        return module != null && (module.enabled || module.disabledByOverlap);
    }

    public QuarkModule getModuleInstance(Class<? extends QuarkModule> moduleClazz) {
        return this.foundModules.get(moduleClazz);
    }

    public boolean isItemEnabled(Item i) {
        BlockItem bi;
        Block b;
        if (i instanceof IQuarkItem) {
            IQuarkItem qi = (IQuarkItem)i;
            return qi.isEnabled();
        }
        if (i instanceof BlockItem && (b = (bi = (BlockItem)i).m_40614_()) instanceof IQuarkBlock) {
            IQuarkBlock qb = (IQuarkBlock)b;
            return qb.isEnabled();
        }
        return true;
    }

    public void initJEICompat(Runnable jeiRunnable) {
        this.onConfigReloadJEI = jeiRunnable;
    }

    private static enum Step {
        CONSTRUCT,
        CONSTRUCT_CLIENT,
        REGISTER,
        POST_REGISTER,
        CONFIG_CHANGED,
        CONFIG_CHANGED_CLIENT,
        SETUP,
        SETUP_CLIENT,
        MODEL_REGISTRY,
        MODEL_BAKE,
        MODEL_LAYERS,
        TEXTURE_STITCH,
        POST_TEXTURE_STITCH,
        LOAD_COMPLETE,
        FIRST_CLIENT_TICK;

    }
}

