/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;
import vazkii.quark.base.module.config.type.IBiomeConfig;

public class BiomeTypeConfig
extends AbstractConfigType
implements IBiomeConfig {
    private final Object mutex = new Object();
    @Config(name="Biome Types")
    @Config.Restriction(value={"hot", "cold", "sparse", "dense", "wet", "dry", "savanna", "coniferous", "jungle", "spooky", "dead", "lush", "mushroom", "magical", "rare", "plateau", "modified", "ocean", "river", "water", "mesa", "forest", "plains", "mountain", "hills", "swamp", "sandy", "snowy", "wasteland", "beach", "void", "overworld", "nether", "end", "underground"})
    private List<String> biomeTypeStrings;
    @Config
    private boolean isBlacklist;
    private List<BiomeDictionary.Type> types;

    protected BiomeTypeConfig(boolean isBlacklist, BiomeDictionary.Type ... typesIn) {
        this.isBlacklist = isBlacklist;
        this.biomeTypeStrings = new LinkedList<String>();
        for (BiomeDictionary.Type t : typesIn) {
            this.biomeTypeStrings.add(t.getName().toLowerCase());
        }
    }

    protected BiomeTypeConfig(boolean isBlacklist, String ... types) {
        this.isBlacklist = isBlacklist;
        this.biomeTypeStrings = new LinkedList<String>();
        this.biomeTypeStrings.addAll(Arrays.asList(types));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSpawn(ResourceLocation resource) {
        if (resource == null) {
            return false;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)resource);
        Set biomeTypes = BiomeDictionary.getTypes((ResourceKey)key);
        Object object = this.mutex;
        synchronized (object) {
            if (this.types == null) {
                this.updateTypes();
            }
            for (BiomeDictionary.Type type : biomeTypes) {
                for (BiomeDictionary.Type type2 : this.types) {
                    if (!type2.equals(type)) continue;
                    return !this.isBlacklist;
                }
            }
            return this.isBlacklist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload(ConfigFlagManager flagManager) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateTypes();
        }
    }

    public void updateTypes() {
        this.types = new LinkedList<BiomeDictionary.Type>();
        for (String s : this.biomeTypeStrings) {
            BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            if (type == null) continue;
            this.types.add(type);
        }
    }
}

