/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExclusionRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final CraftingRecipe parent;
    private final List<ResourceLocation> excluded;

    public ExclusionRecipe(CraftingRecipe parent, List<ResourceLocation> excluded) {
        this.parent = parent;
        this.excluded = excluded;
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        for (ResourceLocation recipeLoc : this.excluded) {
            Recipe recipe;
            Optional recipeHolder = worldIn.m_7465_().m_44043_(recipeLoc);
            if (!recipeHolder.isPresent() || !((recipe = (Recipe)recipeHolder.get()) instanceof CraftingRecipe) || !((CraftingRecipe)recipe).m_5818_((Container)inv, worldIn)) continue;
            return false;
        }
        return this.parent.m_5818_((Container)inv, worldIn);
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        return this.parent.m_5874_((Container)inv);
    }

    public boolean m_8004_(int width, int height) {
        return this.parent.m_8004_(width, height);
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.parent.m_8043_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.parent.m_6423_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.parent.m_6671_();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        return this.parent.m_7457_((Container)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.parent.m_7527_();
    }

    public boolean m_5598_() {
        return this.parent.m_5598_();
    }

    @Nonnull
    public String m_6076_() {
        return this.parent.m_6076_();
    }

    @Nonnull
    public ItemStack m_8042_() {
        return this.parent.m_8042_();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ExclusionRecipe> {
        public Serializer() {
            this.setRegistryName("quark:exclusion");
        }

        @Nonnull
        public ExclusionRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String trueType = GsonHelper.m_13906_((JsonObject)json, (String)"true_type");
            if (trueType.equals("quark:exclusion")) {
                throw new JsonSyntaxException("Recipe type circularity");
            }
            JsonArray excluded = GsonHelper.m_13933_((JsonObject)json, (String)"exclusions");
            ArrayList<ResourceLocation> excludedRecipes = new ArrayList<ResourceLocation>();
            for (JsonElement el : excluded) {
                ResourceLocation loc = new ResourceLocation(el.getAsString());
                if (loc.equals((Object)recipeId)) continue;
                excludedRecipes.add(loc);
            }
            Optional serializer = Registry.f_122865_.m_6612_(new ResourceLocation(trueType));
            if (serializer.isEmpty()) {
                throw new JsonSyntaxException("Invalid or unsupported recipe type '" + trueType + "'");
            }
            Recipe parent = ((RecipeSerializer)serializer.get()).m_6729_(recipeId, json);
            if (!(parent instanceof CraftingRecipe)) {
                throw new JsonSyntaxException("Type '" + trueType + "' is not a crafting recipe");
            }
            if (parent instanceof IShapedRecipe) {
                return new ShapedExclusionRecipe((CraftingRecipe)parent, excludedRecipes);
            }
            return new ExclusionRecipe((CraftingRecipe)parent, excludedRecipes);
        }

        @Nonnull
        public ExclusionRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            int exclusions = buffer.m_130242_();
            ArrayList<ResourceLocation> excludedRecipes = new ArrayList<ResourceLocation>();
            for (int i = 0; i < exclusions; ++i) {
                ResourceLocation loc = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
                if (loc.equals((Object)recipeId)) continue;
                excludedRecipes.add(loc);
            }
            String trueType = buffer.m_130136_(Short.MAX_VALUE);
            RecipeSerializer serializer = (RecipeSerializer)Registry.f_122865_.m_6612_(new ResourceLocation(trueType)).orElseThrow(() -> new IllegalArgumentException("Invalid or unsupported recipe type '" + trueType + "'"));
            Recipe parent = serializer.m_8005_(recipeId, buffer);
            if (!(parent instanceof CraftingRecipe)) {
                throw new IllegalArgumentException("Type '" + trueType + "' is not a crafting recipe");
            }
            if (parent instanceof IShapedRecipe) {
                return new ShapedExclusionRecipe((CraftingRecipe)parent, excludedRecipes);
            }
            return new ExclusionRecipe((CraftingRecipe)parent, excludedRecipes);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ExclusionRecipe recipe) {
            buffer.m_130130_(recipe.excluded.size());
            for (ResourceLocation loc : recipe.excluded) {
                buffer.m_130072_(loc.toString(), Short.MAX_VALUE);
            }
            buffer.m_130072_(Objects.toString(recipe.parent.m_7707_().getRegistryName()), Short.MAX_VALUE);
            recipe.parent.m_7707_().m_6178_(buffer, (Recipe)recipe.parent);
        }
    }

    private static class ShapedExclusionRecipe
    extends ExclusionRecipe
    implements IShapedRecipe<CraftingContainer> {
        private final IShapedRecipe<CraftingContainer> parent;

        public ShapedExclusionRecipe(CraftingRecipe parent, List<ResourceLocation> excluded) {
            super(parent, excluded);
            this.parent = (IShapedRecipe)parent;
        }

        public int getRecipeWidth() {
            return this.parent.getRecipeWidth();
        }

        public int getRecipeHeight() {
            return this.parent.getRecipeHeight();
        }
    }
}

