/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import vazkii.quark.base.handler.BrewingHandler;

public class PotionIngredient
extends Ingredient {
    private final Item item;
    private final Potion potion;

    public PotionIngredient(Item item, Potion potion) {
        super(Stream.of(new Ingredient.ItemValue(BrewingHandler.of(item, potion))));
        this.item = item;
        this.potion = potion;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.item == input.m_41720_() && PotionUtils.m_43579_((ItemStack)input) == this.potion;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.toString(CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE)));
        json.addProperty("item", Objects.toString(this.item.getRegistryName()));
        json.addProperty("potion", Objects.toString(this.potion.getRegistryName()));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PotionIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public PotionIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            Item item = (Item)Registry.f_122827_.m_6612_(buffer.m_130281_()).get();
            Potion potion = (Potion)Registry.f_122828_.m_6612_(buffer.m_130281_()).get();
            return new PotionIngredient(item, potion);
        }

        @Nonnull
        public PotionIngredient parse(@Nonnull JsonObject json) {
            Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(json.getAsJsonPrimitive("item").getAsString())).get();
            Potion potion = (Potion)Registry.f_122828_.m_6612_(new ResourceLocation(json.getAsJsonPrimitive("item").getAsString())).get();
            return new PotionIngredient(item, potion);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull PotionIngredient ingredient) {
            buffer.m_130070_(Objects.toString(Registry.f_122827_.m_7447_((Object)ingredient.item)));
            buffer.m_130070_(Objects.toString(Registry.f_122828_.m_7447_((Object)ingredient.potion)));
        }
    }
}

