/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.ForgeMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.MiscUtil;

public class AttributeTooltips {
    private static final Attribute MAX_HEALTH = Attributes.f_22276_;
    private static final Attribute KNOCKBACK_RESISTANCE = Attributes.f_22278_;
    private static final Attribute MOVEMENT_SPEED = Attributes.f_22279_;
    private static final Attribute ATTACK_DAMAGE = Attributes.f_22281_;
    private static final Attribute ATTACK_SPEED = Attributes.f_22283_;
    private static final Attribute ARMOR = Attributes.f_22284_;
    private static final Attribute ARMOR_TOUGHNESS = Attributes.f_22285_;
    private static final Attribute LUCK = Attributes.f_22286_;
    private static final Attribute ATTACK_KNOCKBACK = Attributes.f_22282_;
    private static final Attribute REACH_DISTANCE = (Attribute)ForgeMod.REACH_DISTANCE.get();
    private static final Attribute SWIM_SPEED = (Attribute)ForgeMod.SWIM_SPEED.get();
    private static final Attribute ENTITY_GRAVITY = (Attribute)ForgeMod.ENTITY_GRAVITY.get();
    public static final ImmutableSet<Attribute> VALID_ATTRIBUTES = ImmutableSet.of((Object)ATTACK_DAMAGE, (Object)ATTACK_SPEED, (Object)REACH_DISTANCE, (Object)ARMOR, (Object)ARMOR_TOUGHNESS, (Object)KNOCKBACK_RESISTANCE, (Object[])new Attribute[]{MAX_HEALTH, MOVEMENT_SPEED, LUCK, SWIM_SPEED, ENTITY_GRAVITY, ATTACK_KNOCKBACK});
    private static final ImmutableSet<Attribute> MULTIPLIER_ATTRIBUTES = ImmutableSet.of((Object)MOVEMENT_SPEED, (Object)SWIM_SPEED, (Object)ENTITY_GRAVITY);
    private static final ImmutableSet<Attribute> POTION_MULTIPLIER_ATTRIBUTES = ImmutableSet.of((Object)ATTACK_SPEED);
    private static final ImmutableSet<Attribute> PERCENT_ATTRIBUTES = ImmutableSet.of((Object)KNOCKBACK_RESISTANCE, (Object)LUCK);
    private static final ImmutableSet<Attribute> DIFFERENCE_ATTRIBUTES = ImmutableSet.of((Object)MAX_HEALTH, (Object)REACH_DISTANCE);
    private static final ImmutableSet<Attribute> NONMAIN_DIFFERENCE_ATTRIBUTES = ImmutableSet.of((Object)ATTACK_DAMAGE, (Object)ATTACK_SPEED, (Object)ATTACK_KNOCKBACK);
    private static final UUID DUMMY_UUID = new UUID(0L, 0L);
    private static final AttributeModifier DUMMY_MODIFIER = new AttributeModifier(DUMMY_UUID, "NO-OP", 0.0, AttributeModifier.Operation.ADDITION);
    private static final ImmutableSet<String> ATTRIBUTE_FORMATS = ImmutableSet.of((Object)"plus", (Object)"take", (Object)"equals");

    private static String format(Attribute attribute, double value, EquipmentSlot slot) {
        if (PERCENT_ATTRIBUTES.contains((Object)attribute)) {
            return (value > 0.0 ? "+" : "") + ItemStack.f_41584_.format(value * 100.0) + "%";
        }
        if (MULTIPLIER_ATTRIBUTES.contains((Object)attribute) || slot == null && POTION_MULTIPLIER_ATTRIBUTES.contains((Object)attribute)) {
            return ItemStack.f_41584_.format(value / AttributeTooltips.baseValue(attribute)) + "x";
        }
        if (DIFFERENCE_ATTRIBUTES.contains((Object)attribute) || slot != EquipmentSlot.MAINHAND && NONMAIN_DIFFERENCE_ATTRIBUTES.contains((Object)attribute)) {
            return (value > 0.0 ? "+" : "") + ItemStack.f_41584_.format(value);
        }
        return ItemStack.f_41584_.format(value);
    }

    private static double baseValue(Attribute attribute) {
        if (attribute == MOVEMENT_SPEED) {
            return 0.1;
        }
        if (attribute == ATTACK_SPEED) {
            return 4.0;
        }
        if (attribute == MAX_HEALTH) {
            return 20.0;
        }
        return 1.0;
    }

    private static int renderPosition(Attribute attribute) {
        if (attribute == ATTACK_DAMAGE) {
            return 1;
        }
        if (attribute == ATTACK_SPEED) {
            return 2;
        }
        if (attribute == REACH_DISTANCE) {
            return 3;
        }
        if (attribute == ARMOR) {
            return 4;
        }
        if (attribute == ARMOR_TOUGHNESS) {
            return 5;
        }
        if (attribute == KNOCKBACK_RESISTANCE) {
            return 6;
        }
        if (attribute == MOVEMENT_SPEED) {
            return 7;
        }
        if (attribute == LUCK) {
            return 8;
        }
        if (attribute == SWIM_SPEED) {
            return 9;
        }
        if (attribute == ENTITY_GRAVITY) {
            return 10;
        }
        if (attribute == MAX_HEALTH) {
            return 11;
        }
        if (attribute == ATTACK_KNOCKBACK) {
            return 12;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = event.getItemStack();
        if (!Screen.m_96638_()) {
            List tooltipRaw = event.getTooltipElements();
            HashMap attributeTooltips = Maps.newHashMap();
            boolean onlyInvalid = true;
            Multimap<Attribute, AttributeModifier> baseCheck = null;
            boolean allAreSame = true;
            EquipmentSlot[] slots = EquipmentSlot.values();
            for (EquipmentSlot slot : slots = Arrays.copyOf(slots, slots.length + 1)) {
                if (!AttributeTooltips.canStripAttributes(stack, slot)) continue;
                Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(stack, slot);
                if (baseCheck == null) {
                    baseCheck = slotAttributes;
                } else if (slot != null && allAreSame && !slotAttributes.equals(baseCheck)) {
                    allAreSame = false;
                }
                if (!slotAttributes.isEmpty()) {
                    if (slot == null) {
                        allAreSame = false;
                    }
                    String slotDesc = slot == null ? "potion.whenDrank" : "item.modifiers." + slot.m_20751_();
                    int index = -1;
                    for (int i = 0; i < tooltipRaw.size(); ++i) {
                        Either component = (Either)tooltipRaw.get(i);
                        Optional left = component.left();
                        if (!left.isPresent() || !AttributeTooltips.equalsOrSibling((FormattedText)left.get(), slotDesc)) continue;
                        index = i;
                        break;
                    }
                    if (index < 0) continue;
                    tooltipRaw.remove(index - 1);
                    tooltipRaw.remove(index - 1);
                }
                onlyInvalid = AttributeTooltips.extractAttributeValues(stack, tooltipRaw, attributeTooltips, onlyInvalid, slot, slotAttributes);
            }
            EquipmentSlot primarySlot = Mob.m_147233_((ItemStack)stack);
            boolean showSlots = !allAreSame && (onlyInvalid || attributeTooltips.size() == 1 && attributeTooltips.containsKey(primarySlot));
            for (int i = 0; i < slots.length; ++i) {
                EquipmentSlot slot;
                slot = slots[slots.length - (i + 1)];
                if (!attributeTooltips.containsKey(slot)) continue;
                String stringForSlot = ((StringBuilder)attributeTooltips.get(slot)).toString();
                int len = 16;
                if (stringForSlot.contains("/")) {
                    String[] toks;
                    stringForSlot = stringForSlot.substring(0, stringForSlot.length() - 1);
                    for (String tok : toks = stringForSlot.split("/")) {
                        len += mc.f_91062_.m_92895_(tok) + 5;
                    }
                }
                if (showSlots) {
                    len += 20;
                }
                tooltipRaw.add(1, Either.right((Object)new AttributeComponent(stack, len, 10)));
                if (allAreSame) break;
            }
        }
    }

    public static Multimap<Attribute, AttributeModifier> getModifiers(ItemStack stack, EquipmentSlot slot) {
        if (slot == null) {
            List potions = PotionUtils.m_43547_((ItemStack)stack);
            HashMultimap out = HashMultimap.create();
            for (MobEffectInstance effect : potions) {
                MobEffect potion = effect.m_19544_();
                Map map = potion.m_19485_();
                for (Attribute attribute : map.keySet()) {
                    AttributeModifier baseModifier = (AttributeModifier)map.get(attribute);
                    AttributeModifier amplified = new AttributeModifier(baseModifier.m_22214_(), potion.m_7048_(effect.m_19564_(), baseModifier), baseModifier.m_22217_());
                    out.put((Object)attribute, (Object)amplified);
                }
            }
            return out;
        }
        Multimap out = stack.m_41638_(slot);
        out = out.isEmpty() ? HashMultimap.create() : HashMultimap.create((Multimap)out);
        if (slot == EquipmentSlot.MAINHAND) {
            if (EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_) > 0.0f) {
                out.put((Object)ATTACK_DAMAGE, (Object)DUMMY_MODIFIER);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack) > 0) {
                out.put((Object)ATTACK_KNOCKBACK, (Object)DUMMY_MODIFIER);
            }
            if (out.containsKey((Object)ATTACK_DAMAGE) && !out.containsKey((Object)ATTACK_SPEED)) {
                out.put((Object)ATTACK_SPEED, (Object)DUMMY_MODIFIER);
            } else if (out.containsKey((Object)ATTACK_SPEED) && !out.containsKey((Object)ATTACK_DAMAGE)) {
                out.put((Object)ATTACK_DAMAGE, (Object)DUMMY_MODIFIER);
            }
        }
        return out;
    }

    public static boolean extractAttributeValues(ItemStack stack, List<Either<FormattedText, TooltipComponent>> tooltip, Map<EquipmentSlot, StringBuilder> attributeTooltips, boolean onlyInvalid, EquipmentSlot slot, Multimap<Attribute, AttributeModifier> slotAttributes) {
        boolean anyInvalid = false;
        block0: for (Attribute attr : slotAttributes.keySet()) {
            if (VALID_ATTRIBUTES.contains((Object)attr)) {
                onlyInvalid = false;
                Minecraft mc = Minecraft.m_91087_();
                double attributeValue = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, stack, slotAttributes, attr);
                if (attributeValue != 0.0) {
                    if (!attributeTooltips.containsKey(slot)) {
                        attributeTooltips.put(slot, new StringBuilder());
                    }
                    attributeTooltips.get(slot).append(AttributeTooltips.format(attr, attributeValue, slot)).append("/");
                }
            } else if (!anyInvalid) {
                anyInvalid = true;
                if (!attributeTooltips.containsKey(slot)) {
                    attributeTooltips.put(slot, new StringBuilder());
                }
                attributeTooltips.get(slot).append("[+]");
            }
            for (int i = 1; i < tooltip.size(); ++i) {
                Either<FormattedText, TooltipComponent> either = tooltip.get(i);
                if (either == null || !either.left().isPresent() || !AttributeTooltips.isAttributeLine((FormattedText)either.left().get(), attr)) continue;
                tooltip.remove(i);
                continue block0;
            }
        }
        return onlyInvalid;
    }

    private static TranslatableComponent getMatchingOrSibling(FormattedText component, String key) {
        if (component instanceof TranslatableComponent) {
            return key.equals(((TranslatableComponent)component).m_131328_()) ? (TranslatableComponent)component : null;
        }
        if (component instanceof Component) {
            for (Component sibling : ((Component)component).m_7360_()) {
                if (!(sibling instanceof TranslatableComponent)) continue;
                return AttributeTooltips.getMatchingOrSibling((FormattedText)sibling, key);
            }
        }
        return null;
    }

    private static boolean equalsOrSibling(FormattedText component, String key) {
        return AttributeTooltips.getMatchingOrSibling(component, key) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isAttributeLine(FormattedText lineRaw, Attribute attr) {
        String attNamePattern = attr.m_22087_();
        for (String att : ATTRIBUTE_FORMATS) {
            for (int mod = 0; mod < 3; ++mod) {
                Object formatArg;
                Object[] formatArgs;
                String pattern = "attribute.modifier." + att + "." + mod;
                TranslatableComponent line = AttributeTooltips.getMatchingOrSibling(lineRaw, pattern);
                if (line == null || (formatArgs = line.m_131329_()).length <= 1 || !((formatArg = formatArgs[1]) instanceof Component) || !AttributeTooltips.equalsOrSibling((FormattedText)((Component)formatArg), attNamePattern)) continue;
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int renderAttribute(PoseStack matrix, Attribute attribute, EquipmentSlot slot, int x, int y, ItemStack stack, Multimap<Attribute, AttributeModifier> slotAttributes, Minecraft mc) {
        double value = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, stack, slotAttributes, attribute);
        if (value != 0.0) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.ATTRIBUTE_ICONS);
            int renderPosition = AttributeTooltips.renderPosition(attribute);
            int renderX = renderPosition % 28;
            int renderY = renderPosition / 28;
            GuiComponent.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)(renderX * 9), (float)(renderY * 9), (int)9, (int)9, (int)256, (int)256);
            String valueStr = AttributeTooltips.format(attribute, value, slot);
            int color = value < 0.0 || valueStr.endsWith("x") && value / AttributeTooltips.baseValue(attribute) < 1.0 ? 0xFF5555 : 0xFFFFFF;
            mc.f_91062_.m_92750_(matrix, valueStr, (float)(x + 12), (float)(y + 1), color);
            x += mc.f_91062_.m_92895_(valueStr) + 20;
        }
        return x;
    }

    private static EquipmentSlot getPrimarySlot(ItemStack stack) {
        if (stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof TippedArrowItem) {
            return null;
        }
        return Mob.m_147233_((ItemStack)stack);
    }

    private static boolean canStripAttributes(ItemStack stack, @Nullable EquipmentSlot slot) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot == null) {
            return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 0x20) == 0;
        }
        return (ItemNBTHelper.getInt((ItemStack)stack, (String)"HideFlags", (int)0) & 2) == 0;
    }

    private static double getAttribute(Player player, EquipmentSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, Attribute key) {
        AttributeInstance attribute;
        AttributeInstance attribute2;
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        double value = 0.0;
        if (!(PERCENT_ATTRIBUTES.contains((Object)key) || slot == null && key.equals(ATTACK_DAMAGE) || (attribute2 = player.m_21051_(key)) == null)) {
            value = attribute2.m_22115_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            value += modifier.m_22218_();
        }
        double rawValue = value;
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            value += rawValue * modifier.m_22218_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            value += value * modifier.m_22218_();
        }
        if (key.equals(ATTACK_DAMAGE) && slot == EquipmentSlot.MAINHAND) {
            value += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        if (key.equals(ATTACK_KNOCKBACK) && slot == EquipmentSlot.MAINHAND) {
            value += (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack);
        }
        if ((DIFFERENCE_ATTRIBUTES.contains((Object)key) || slot != EquipmentSlot.MAINHAND && NONMAIN_DIFFERENCE_ATTRIBUTES.contains((Object)key)) && (slot != null || !key.equals(ATTACK_DAMAGE)) && (attribute = player.m_21051_(key)) != null) {
            value -= attribute.m_22115_();
        }
        return value;
    }

    public record AttributeComponent(ItemStack stack, int width, int height) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack pose, @Nonnull ItemRenderer itemRenderer, int something) {
            if (!Screen.m_96638_()) {
                pose.m_85836_();
                pose.m_85837_(0.0, 0.0, 500.0);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft mc = Minecraft.m_91087_();
                pose.m_85837_(0.0, 0.0, (double)mc.m_91291_().f_115093_);
                int y = tooltipY - 1;
                EquipmentSlot primarySlot = AttributeTooltips.getPrimarySlot(this.stack);
                boolean onlyInvalid = true;
                boolean showSlots = false;
                int attributeHash = 0;
                boolean allAreSame = true;
                EquipmentSlot[] slots = EquipmentSlot.values();
                block0: for (EquipmentSlot slot : slots = Arrays.copyOf(slots, slots.length + 1)) {
                    if (!AttributeTooltips.canStripAttributes(this.stack, slot)) continue;
                    Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, slot);
                    if (slot == EquipmentSlot.MAINHAND) {
                        attributeHash = slotAttributes.hashCode();
                    } else if (allAreSame && attributeHash != slotAttributes.hashCode()) {
                        allAreSame = false;
                    }
                    for (Attribute attr : slotAttributes.keys()) {
                        if (!VALID_ATTRIBUTES.contains((Object)attr)) continue;
                        onlyInvalid = false;
                        if (slot == primarySlot) continue;
                        showSlots = true;
                        break block0;
                    }
                }
                if (allAreSame) {
                    showSlots = false;
                } else if (onlyInvalid) {
                    showSlots = true;
                }
                for (EquipmentSlot slot : slots) {
                    if (!AttributeTooltips.canStripAttributes(this.stack, slot)) continue;
                    int x = tooltipX;
                    Multimap<Attribute, AttributeModifier> slotAttributes = AttributeTooltips.getModifiers(this.stack, slot);
                    boolean anyToRender = false;
                    for (Attribute attr : slotAttributes.keys()) {
                        double value = AttributeTooltips.getAttribute((Player)mc.f_91074_, slot, this.stack, slotAttributes, attr);
                        if (value == 0.0) continue;
                        anyToRender = true;
                        break;
                    }
                    if (!anyToRender) continue;
                    if (showSlots) {
                        RenderSystem.m_157427_(GameRenderer::m_172817_);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
                        GuiComponent.m_93133_((PoseStack)pose, (int)x, (int)y, (float)(202 + (slot == null ? -1 : slot.ordinal()) * 9), (float)35.0f, (int)9, (int)9, (int)256, (int)256);
                        x += 20;
                    }
                    for (Attribute key : VALID_ATTRIBUTES) {
                        x = AttributeTooltips.renderAttribute(pose, key, slot, x, y, this.stack, slotAttributes, mc);
                    }
                    for (Attribute key : slotAttributes.keys()) {
                        if (VALID_ATTRIBUTES.contains((Object)key)) continue;
                        mc.f_91062_.m_92750_(pose, "[+]", (float)(x + 1), (float)(y + 1), 0xFFFF55);
                        break;
                    }
                    y += 10;
                    if (allAreSame) break;
                }
                pose.m_85849_();
            }
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(@Nonnull Font font) {
            return this.width;
        }
    }
}

