/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class AbacusItem
extends QuarkItem {
    public static final String TAG_POS_X = "boundPosX";
    public static final String TAG_POS_Y = "boundPosY";
    public static final String TAG_POS_Z = "boundPosZ";
    public static int MAX_COUNT = 48;

    public AbacusItem(QuarkModule module) {
        super("abacus", module, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos curr = AbacusItem.getBlockPos(stack);
        if (curr != null) {
            AbacusItem.setBlockPos(stack, null);
        } else {
            AbacusItem.setBlockPos(stack, context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }

    public static void setBlockPos(ItemStack stack, BlockPos pos) {
        if (pos == null) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)-1);
        } else {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)pos.m_123341_());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)pos.m_123342_());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)pos.m_123343_());
        }
    }

    public static BlockPos getBlockPos(ItemStack stack) {
        int y = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Y, (int)-1);
        if (y == -1) {
            return null;
        }
        int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
        int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
        return new BlockPos(x, y, z);
    }

    public static int getCount(ItemStack stack, BlockPos target, Level world) {
        BlockPos pos = AbacusItem.getBlockPos(stack);
        if (pos != null && !world.m_46859_(target)) {
            return target.m_123333_((Vec3i)pos);
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getCount(ItemStack stack, LivingEntity entityIn) {
        HitResult result;
        int count = -1;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (entityIn == player && player != null && (result = mc.f_91077_) instanceof BlockHitResult) {
            BlockPos target = ((BlockHitResult)result).m_82425_();
            count = AbacusItem.getCount(stack, target, player.f_19853_);
        }
        return count;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float count(ItemStack stack, ClientLevel world, LivingEntity entityIn, int id) {
        int count = AbacusItem.getCount(stack, entityIn);
        if (count == -1) {
            return 9999.0f;
        }
        return 0.01f * (float)count + 0.005f;
    }
}

