/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import vazkii.quark.content.tweaks.ai.WantLoveGoal;

public class NuzzleGoal
extends Goal {
    private final TamableAnimal creature;
    private LivingEntity owner;
    private final double followSpeed;
    private final PathNavigation petPathfinder;
    private int timeUntilRebuildPath;
    private final float maxDist;
    private final float whineDist;
    private int whineCooldown;
    private float oldWaterCost;
    private final SoundEvent whine;

    public NuzzleGoal(TamableAnimal creature, double followSpeed, float maxDist, float whineDist, SoundEvent whine) {
        this.creature = creature;
        this.followSpeed = followSpeed;
        this.petPathfinder = creature.m_21573_();
        this.maxDist = maxDist;
        this.whineDist = whineDist;
        this.whine = whine;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        if (!(creature.m_21573_() instanceof GroundPathNavigation) && !(creature.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for NuzzleOwnerGoal");
        }
    }

    public boolean m_8036_() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        LivingEntity living = this.creature.m_142480_();
        if (living == null || living.m_5833_() || this.creature.m_21827_()) {
            return false;
        }
        this.owner = living;
        return true;
    }

    public boolean m_8045_() {
        if (!WantLoveGoal.needsPets(this.creature)) {
            return false;
        }
        return !this.petPathfinder.m_26571_() && this.creature.m_20280_((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.creature.m_21827_();
    }

    public void m_8056_() {
        this.timeUntilRebuildPath = 0;
        this.whineCooldown = 10;
        this.oldWaterCost = this.creature.m_21439_(BlockPathTypes.WATER);
        this.creature.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.petPathfinder.m_26573_();
        this.creature.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.creature.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.creature.m_8132_());
        if (!this.creature.m_21827_() && --this.timeUntilRebuildPath <= 0) {
            this.timeUntilRebuildPath = 10;
            this.petPathfinder.m_5624_((Entity)this.owner, this.followSpeed);
        }
        if (this.creature.m_20280_((Entity)this.owner) < (double)this.whineDist && --this.whineCooldown <= 0) {
            this.whineCooldown = 80 + this.creature.m_21187_().nextInt(40);
            this.creature.m_5496_(this.whine, 1.0f, 0.5f + (float)Math.random() * 0.5f);
        }
    }
}

