/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.gen.FairyRingGenerator;

@LoadModule(category=ModuleCategory.WORLD)
public class FairyRingsModule
extends QuarkModule {
    @Config
    public static double forestChance = 0.00625;
    @Config
    public static double plainsChance = 0.0025;
    @Config
    public static DimensionConfig dimensions = new DimensionConfig(false, "minecraft:overworld");
    @Config(name="Ores")
    public static List<String> oresRaw = Lists.newArrayList((Object[])new String[]{"minecraft:emerald_ore", "minecraft:diamond_ore"});
    public static List<BlockState> ores;

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new FairyRingGenerator(dimensions), GenerationStep.Decoration.TOP_LAYER_MODIFICATION, 0);
    }

    @Override
    public void configChanged() {
        ores = new ArrayList<BlockState>();
        for (String s : oresRaw) {
            Optional b = Registry.f_122824_.m_6612_(new ResourceLocation(s));
            if (b.isPresent()) {
                ores.add(((Block)b.get()).m_49966_());
                continue;
            }
            new IllegalArgumentException("Block " + s + " does not exist!").printStackTrace();
        }
    }
}

