/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common;

import doggytalents.DoggyItems;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.TreatBagContainer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;

public class Screens {
    public static void openPackPuppyScreen(ServerPlayer player, AbstractDogEntity dogIn) {
        if (dogIn.m_6084_()) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new PackPuppyContainerProvider(dogIn), buf -> buf.writeInt(dogIn.m_142049_()));
        }
    }

    public static void openDogInventoriesScreen(ServerPlayer player, List<DogEntity> dogIn) {
        if (!dogIn.isEmpty()) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new DogInventoriesContainerProvider(dogIn), buf -> {
                buf.writeInt(dogIn.size());
                for (DogEntity dog : dogIn) {
                    buf.writeInt(dog.m_142049_());
                }
            });
        }
    }

    public static void openFoodBowlScreen(ServerPlayer player, FoodBowlTileEntity foodBowl) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)foodBowl, (BlockPos)foodBowl.m_58899_());
    }

    public static void openTreatBagScreen(ServerPlayer player, ItemStack stackIn, int slotId) {
        if (stackIn.m_41720_() == DoggyItems.TREAT_BAG.get()) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new TreatBagContainerProvider(stackIn, slotId), buf -> {
                buf.m_130130_(slotId);
                buf.m_130055_(stackIn);
            });
        }
    }

    public static class PackPuppyContainerProvider
    implements MenuProvider {
        private AbstractDogEntity dog;

        public PackPuppyContainerProvider(AbstractDogEntity dogIn) {
            this.dog = dogIn;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new PackPuppyContainer(windowId, inventory, this.dog);
        }

        public Component m_5446_() {
            return new TranslatableComponent("container.doggytalents.pack_puppy");
        }
    }

    public static class DogInventoriesContainerProvider
    implements MenuProvider {
        private List<DogEntity> dogs;

        public DogInventoriesContainerProvider(List<DogEntity> dogIn) {
            this.dogs = dogIn;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            SimpleContainerData array = new SimpleContainerData(this.dogs.size());
            for (int i = 0; i < array.m_6499_(); ++i) {
                array.m_8050_(i, this.dogs.get(i).m_142049_());
            }
            return new DogInventoriesContainer(windowId, inventory, array);
        }

        public Component m_5446_() {
            return new TranslatableComponent("container.doggytalents.dog_inventories");
        }
    }

    public static class TreatBagContainerProvider
    implements MenuProvider {
        private ItemStack stack;
        private int slotId;

        public TreatBagContainerProvider(ItemStack stackIn, int slotId) {
            this.stack = stackIn;
            this.slotId = slotId;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return new TreatBagContainer(windowId, inventory, this.slotId, this.stack);
        }

        public Component m_5446_() {
            return new TranslatableComponent("container.doggytalents.treat_bag");
        }
    }
}

