/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedBlock
extends BaseEntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);

    public DogBedBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE_COLLISION;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new DogBedTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return null;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_());
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            DogBedUtil.setBedVariant(dogBedTileEntity, stack);
            dogBedTileEntity.setPlacer(placer);
            CompoundTag tag = stack.m_41737_("doggytalents");
            if (tag != null) {
                Component name = NBTUtil.getTextComponent(tag, "name");
                UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
                dogBedTileEntity.setBedName(name);
                dogBedTileEntity.setOwner(ownerId);
            }
        }
        worldIn.m_7731_(pos, state, 2);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            ItemStack stack = player.m_21120_(handIn);
            if (stack.m_41720_() == Items.f_42656_ && stack.m_41788_()) {
                dogBedTileEntity.setBedName(stack.m_41786_());
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                worldIn.m_7260_(pos, state, state, 3);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && dogBedTileEntity.getOwnerUUID() == null) {
                DogEntity closests;
                List dogs = worldIn.m_142425_((EntityTypeTest)DoggyEntityTypes.DOG.get(), new AABB(pos).m_82400_(10.0), dog -> dog.m_6084_() && dog.m_21830_((LivingEntity)player));
                Collections.sort(dogs, new EntityUtil.Sorter(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())));
                DogEntity closestStanding = null;
                DogEntity closestSitting = null;
                for (DogEntity dog2 : dogs) {
                    if (closestSitting != null && closestSitting != null) break;
                    if (closestSitting == null && dog2.m_21825_()) {
                        closestSitting = dog2;
                        continue;
                    }
                    if (closestStanding != null || dog2.m_21825_()) continue;
                    closestStanding = dog2;
                }
                DogEntity dogEntity = closests = closestStanding != null ? closestStanding : closestSitting;
                if (closests != null) {
                    closests.setTargetBlock(pos);
                }
            } else {
                if (dogBedTileEntity.getOwnerUUID() != null) {
                    DogRespawnData storage = DogRespawnStorage.get(worldIn).remove(dogBedTileEntity.getOwnerUUID());
                    if (storage != null) {
                        DogEntity dog3 = storage.respawn((ServerLevel)worldIn, player, pos.m_7494_());
                        dogBedTileEntity.setOwner(dog3);
                        dog3.setBedPos((ResourceKey<Level>)dog3.f_19853_.m_46472_(), pos);
                        return InteractionResult.SUCCESS;
                    }
                    Component name = dogBedTileEntity.getOwnerName();
                    player.m_6352_((Component)new TranslatableComponent("block.doggytalents.dog_bed.owner", new Object[]{name != null ? name : "someone"}), Util.f_137441_);
                    return InteractionResult.FAIL;
                }
                player.m_6352_((Component)new TranslatableComponent("block.doggytalents.dog_bed.set_owner_help"), Util.f_137441_);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag;
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        tooltip.add((Component)(materials.getLeft() != null ? ((ICasingMaterial)((Object)materials.getLeft())).getTooltip() : new TranslatableComponent("dogbed.casing.null").m_130940_(ChatFormatting.RED)));
        tooltip.add((Component)(materials.getRight() != null ? ((IBeddingMaterial)((Object)materials.getRight())).getTooltip() : new TranslatableComponent("dogbed.bedding.null").m_130940_(ChatFormatting.RED)));
        if (materials.getLeft() == null && materials.getRight() == null) {
            tooltip.add((Component)new TranslatableComponent("dogbed.explain.missing").m_130940_(ChatFormatting.ITALIC));
        }
        if ((tag = stack.m_41737_("doggytalents")) != null) {
            UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
            Component name = NBTUtil.getTextComponent(tag, "name");
            Component ownerName = NBTUtil.getTextComponent(tag, "ownerName");
            if (name != null) {
                tooltip.add((Component)new TextComponent("Bed Name: ").m_130940_(ChatFormatting.WHITE).m_7220_(name));
            }
            if (ownerName != null) {
                tooltip.add((Component)new TextComponent("Name: ").m_130940_(ChatFormatting.DARK_AQUA).m_7220_(ownerName));
            }
            if (ownerId != null && (flagIn.m_7050_() || Screen.m_96638_())) {
                tooltip.add((Component)new TextComponent("UUID: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)new TextComponent(ownerId.toString())));
            }
        }
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        for (IBeddingMaterial beddingId : DoggyTalentsAPI.BEDDING_MATERIAL.get().getValues()) {
            for (ICasingMaterial casingId : DoggyTalentsAPI.CASING_MATERIAL.get().getValues()) {
                items.add((Object)DogBedUtil.createItemStack(casingId, beddingId));
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity(world, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            return DogBedUtil.createItemStack(dogBedTileEntity.getCasing(), dogBedTileEntity.getBedding());
        }
        DoggyTalents2.LOGGER.debug("Unable to pick block on dog bed.");
        return ItemStack.f_41583_;
    }
}

