/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.google.common.collect.Maps;
import doggytalents.DoggyItems;
import doggytalents.common.util.Util;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class DoggyTalentsAdvancements
implements Consumer<Consumer<Advancement>> {
    @Override
    public void accept(Consumer<Advancement> register) {
        Advancement advancement = Advancement.Builder.m_138353_().m_138371_((ItemLike)DoggyItems.TRAINING_TREAT.get(), (Component)new TranslatableComponent("advancements.dog.root.title"), (Component)new TranslatableComponent("advancements.dog.root.description"), new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"), FrameType.TASK, false, false, false).m_138386_("crafting_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50091_})).m_138389_(register, Util.getResourcePath("dog/find_dog"));
        Advancement advancement1 = Advancement.Builder.m_138353_().m_138398_(advancement).m_138371_((ItemLike)Items.f_42422_, (Component)new TranslatableComponent("advancements.dog.mine_stone.title"), (Component)new TranslatableComponent("advancements.dog.mine_stone.description"), (ResourceLocation)null, FrameType.TASK, true, true, false).m_138386_("get_stone", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50652_})).m_138389_(register, Util.getResourcePath("dog/level_talent"));
        Advancement advancement2 = Advancement.Builder.m_138353_().m_138398_(advancement1).m_138371_((ItemLike)DoggyItems.CAPE.get(), (Component)new TranslatableComponent("advancements.dog.upgrade_tools.title"), (Component)new TranslatableComponent("advancements.dog.upgrade_tools.description"), (ResourceLocation)null, FrameType.TASK, true, true, false).m_138386_("stone_pickaxe", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42427_})).m_138389_(register, Util.getResourcePath("dog/accessorise"));
        Advancement advancement3 = Advancement.Builder.m_138353_().m_138398_(advancement2).m_138371_((ItemLike)DoggyItems.RADIO_COLLAR.get(), (Component)new TranslatableComponent("advancements.dog.smelt_iron.title"), (Component)new TranslatableComponent("advancements.dog.smelt_iron.description"), (ResourceLocation)null, FrameType.TASK, true, true, false).m_138386_("iron", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42416_})).m_138389_(register, Util.getResourcePath("dog/radio_collar"));
    }

    public static class Builder {
        private ResourceLocation parentId;
        private Advancement parent;
        private DisplayInfo display;
        private AdvancementRewards rewards = AdvancementRewards.f_9978_;
        private Map<String, Criterion> criteria = Maps.newLinkedHashMap();
        private String[][] requirements;
        private RequirementsStrategy requirementsStrategy = RequirementsStrategy.f_15978_;

        private Builder(@Nullable ResourceLocation parentIdIn, @Nullable DisplayInfo displayIn, AdvancementRewards rewardsIn, Map<String, Criterion> criteriaIn, String[][] requirementsIn) {
            this.parentId = parentIdIn;
            this.display = displayIn;
            this.rewards = rewardsIn;
            this.criteria = criteriaIn;
            this.requirements = requirementsIn;
        }

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withParent(Advancement parentIn) {
            this.parent = parentIn;
            return this;
        }

        public Builder withParentId(ResourceLocation parentIdIn) {
            this.parentId = parentIdIn;
            return this;
        }

        public Builder withDisplay(ItemStack stack, Component title, Component description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.withDisplay(new DisplayInfo(stack, title, description, background, frame, showToast, announceToChat, hidden));
        }

        public Builder withDisplay(ItemLike itemIn, Component title, Component description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.withDisplay(new DisplayInfo(new ItemStack((ItemLike)itemIn.m_5456_()), title, description, background, frame, showToast, announceToChat, hidden));
        }

        public Builder withDisplay(DisplayInfo displayIn) {
            this.display = displayIn;
            return this;
        }

        public Builder withRewards(AdvancementRewards.Builder rewardsBuilder) {
            return this.withRewards(rewardsBuilder.m_10004_());
        }

        public Builder withRewards(AdvancementRewards rewards) {
            this.rewards = rewards;
            return this;
        }

        public Builder withCriterion(String key, CriterionTriggerInstance criterionIn) {
            return this.withCriterion(key, new Criterion(criterionIn));
        }

        public Builder withCriterion(String key, Criterion criterionIn) {
            if (this.criteria.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate criterion " + key);
            }
            this.criteria.put(key, criterionIn);
            return this;
        }

        public Builder withRequirementsStrategy(RequirementsStrategy strategy) {
            this.requirementsStrategy = strategy;
            return this;
        }

        public boolean resolveParent(Function<ResourceLocation, Advancement> lookup) {
            if (this.parentId == null) {
                return true;
            }
            if (this.parent == null) {
                this.parent = lookup.apply(this.parentId);
            }
            return this.parent != null;
        }

        public Advancement build(ResourceLocation id) {
            if (!this.resolveParent(parentID -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.m_15985_(this.criteria.keySet());
            }
            return new Advancement(id, this.parent, this.display, this.rewards, this.criteria, this.requirements);
        }

        public Advancement register(Consumer<Advancement> consumer, String id) {
            Advancement advancement = this.build(new ResourceLocation(id));
            consumer.accept(advancement);
            return advancement;
        }
    }
}

