/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.common.collect.AbstractIterator;
import doggytalents.common.util.RadialCoordinateIterator;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldUtil {
    public static Iterable<BlockPos> getAllInBoxMutable(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return () -> new AbstractIterator<BlockPos>(){
            final RadialCoordinateIterator coordinateIterator;
            final BlockPos.MutableBlockPos mutablePos;
            {
                this.coordinateIterator = new RadialCoordinateIterator(x1, y1, z1, x2, y2, z2);
                this.mutablePos = new BlockPos.MutableBlockPos();
            }

            protected BlockPos computeNext() {
                return this.coordinateIterator.hasNext() ? this.mutablePos.m_122178_(this.coordinateIterator.getX(), this.coordinateIterator.getY(), this.coordinateIterator.getZ()) : (BlockPos)this.endOfData();
            }
        };
    }

    @Nullable
    public static <T extends BlockEntity> T getTileEntity(BlockGetter worldIn, BlockPos posIn, Class<T> type) {
        BlockEntity tileEntity = worldIn.m_7702_(posIn);
        if (tileEntity != null && tileEntity.getClass().isAssignableFrom(type)) {
            return (T)tileEntity;
        }
        return null;
    }

    @Nullable
    public static <T extends Entity> T getCachedEntity(@Nullable Level worldIn, Class<T> type, @Nullable T cached, @Nullable UUID uuid) {
        if ((cached == null || cached.m_146910_()) && uuid != null && worldIn instanceof ServerLevel) {
            Entity entity = ((ServerLevel)worldIn).m_8791_(uuid);
            if (entity != null && entity.getClass().isAssignableFrom(type)) {
                return (T)entity;
            }
            return null;
        }
        return cached;
    }

    public static Optional<BlockPos> toImmutable(BlockPos pos) {
        return pos != null ? Optional.of(pos.m_7949_()) : Optional.empty();
    }

    public static Optional<BlockPos> toImmutable(Optional<BlockPos> pos) {
        return pos.map(BlockPos::m_7949_);
    }
}

