/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityJellyfish;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class EntityBobbitWorm
extends EntityAnimalWithTypes {
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(EntityBobbitWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float lastAttack = 0.0f;
    private float lastGrab = 0.0f;
    private Vec3 targetPosition;

    public EntityBobbitWorm(EntityType<? extends EntityBobbitWorm> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 10.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        HashSet<Class<EntityJellyfish>> blackList = new HashSet<Class<EntityJellyfish>>();
        blackList.add(Skeleton.class);
        blackList.add(EnderMan.class);
        blackList.add(EntityJellyfish.class);
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, true, e -> e.m_20205_() < 3.0f && !(e instanceof Enemy) && !(e instanceof EntityBobbitWorm) && (e.f_19853_.m_46791_() != Difficulty.PEACEFUL || !(e instanceof Player)) && !blackList.contains(e.getClass())));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)state);
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
    }

    protected Vec3 getNewTargetPosition() {
        Vec3 pos = DefaultRandomPos.m_148403_((PathfinderMob)this, (int)20, (int)5);
        if (pos != null && this.isGoodBurrowingPosition(new BlockPos(pos))) {
            return pos;
        }
        if (this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60734_() == Blocks.f_49990_) {
            return new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
        }
        return null;
    }

    public boolean isGoodBurrowingPosition(BlockPos pos) {
        Block below = this.f_19853_.m_8055_(pos.m_7495_()).m_60734_();
        BlockState here = this.f_19853_.m_8055_(pos);
        return (below == Blocks.f_50129_ || below == Blocks.f_49992_ || below == Blocks.f_49994_ || below == Blocks.f_50493_) && here.m_60647_((BlockGetter)this.f_19853_, pos, PathComputationType.WATER) && here.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public void m_7023_(Vec3 vec) {
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            passenger.m_6034_(this.m_20185_(), this.m_20186_() - (double)(this.m_20206_() / 2.0f), this.m_20189_());
        }
    }

    public boolean m_5807_() {
        return false;
    }

    public boolean m_6146_() {
        return true;
    }

    public void m_8119_() {
        Vec3 pos;
        super.m_8119_();
        if (!this.m_20069_()) {
            this.m_20334_(this.m_20184_().m_7096_() * (double)0.2f, this.m_20184_().m_7098_(), this.m_20184_().m_7094_() * (double)0.2f);
            if (!this.m_20068_()) {
                this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() - 0.08, this.m_20184_().m_7094_());
            }
            this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() * (double)0.98f, this.m_20184_().m_7094_());
        } else if (!this.f_19853_.f_46443_) {
            if (this.targetPosition != null) {
                this.m_20334_((this.targetPosition.f_82479_ - this.m_20185_()) * (double)0.05f, (this.targetPosition.f_82480_ - this.m_20186_()) * (double)0.05f, (this.targetPosition.f_82481_ - this.m_20189_()) * (double)0.05f);
            }
            if (this.targetPosition != null && this.targetPosition.m_82557_(this.m_20182_()) < 1.0) {
                this.m_20334_(this.m_20184_().m_7096_() * (double)0.2f, this.m_20184_().m_7098_(), this.m_20184_().m_7094_() * (double)0.2f);
            }
        }
        if (this.f_19853_.f_46443_) {
            this.m_20334_(this.m_20184_().m_7096_() * (double)0.2f, this.m_20184_().m_7098_() * (double)0.2f, this.m_20184_().m_7094_() * (double)0.2f);
        }
        boolean goodPos = this.isGoodBurrowingPosition(this.m_142538_());
        if (this.targetPosition == null && !goodPos && (pos = this.getNewTargetPosition()) != null) {
            this.targetPosition = pos;
        }
        if (this.targetPosition != null && this.targetPosition.m_82557_(this.m_20182_()) < 1.0 && !goodPos) {
            this.targetPosition = null;
        }
        if (this.getAttackState() > 0) {
            this.setAttackState(this.getAttackState() - 1);
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_6084_()) {
            if (this.m_20197_().contains(this.m_5448_())) {
                float time = 30.0f;
                if (this.lastAttack + (time - 20.0f) < (float)this.f_19797_) {
                    this.setAttackState(20);
                }
                if (this.lastAttack + time < (float)this.f_19797_) {
                    this.m_7327_((Entity)this.m_5448_());
                    this.lastAttack = this.f_19797_;
                }
            } else if (this.lastGrab + 60.0f < (float)this.f_19797_ && this.m_20280_((Entity)this.m_5448_()) < 5.0) {
                if (!this.m_5448_().m_20147_() && (double)this.m_5448_().m_20205_() < 2.5 && (double)this.m_5448_().m_20206_() < 2.5) {
                    this.m_5448_().m_7998_((Entity)this, false);
                } else if (!this.m_5448_().m_20147_()) {
                    this.m_7327_((Entity)this.m_5448_());
                }
                this.lastGrab = this.f_19797_;
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(3);
    }

    protected void updateAir(int air) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(air - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19312_, 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.updateAir(i);
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public EntityTypeContainer<EntityBobbitWorm> getContainer() {
        return ModEntities.BOBBIT_WORM;
    }

    @Override
    protected EntityBobbitWorm getBaseChild() {
        return null;
    }
}

