/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.projectile.EntityTarantulaHair;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.ISelectiveVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class EntityTarantula
extends Spider
implements RangedAttackMob,
ISelectiveVariantTypes<EntityTarantula> {
    public EntityTarantula(EntityType<? extends EntityTarantula> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        RangedAttackGoal atkrange = new RangedAttackGoal((RangedAttackMob)this, 1.0, 160, 15.0f);
        atkrange.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.f_21345_.m_25352_(2, (Goal)atkrange);
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        EntityTarantulaHair entityhair = new EntityTarantulaHair((EntityType<? extends EntityTarantulaHair>)((EntityType)ModEntities.PROJECTILE_TARANTULA_HAIR.get()), this.f_19853_, (LivingEntity)this);
        entityhair.m_7678_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0f, 0.0f);
        double d0 = target.m_20186_() + (double)target.m_20192_() - (double)1.1f;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - entityhair.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entityhair.m_6686_(d1, d2 + f, d3, 1.5f, 8.0f);
        this.m_5496_(SoundEvents.f_12642_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)entityhair);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData entityLivingData, CompoundTag itemNbt) {
        this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
        return this.initAgeableData((LevelAccessor)world, reason, super.m_6518_(world, difficulty, reason, entityLivingData, itemNbt));
    }

    public boolean m_6785_(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityTarantula getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<? extends EntityTarantula> getContainer() {
        return ModEntities.TARANTULA;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerTypeKey();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeType(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readType(compound);
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (types.contains(BiomeTypes.JUNGLE)) {
            return new String[]{"jungle_1", "jungle_2", "jungle_3"};
        }
        if (types.contains(BiomeTypes.SANDY)) {
            return new String[]{"desert_1", "desert_2", "desert_3"};
        }
        return new String[]{"desert_1", "desert_2", "desert_3", "jungle_1", "jungle_2", "jungle_3"};
    }
}

