/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.util.abstracts;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityBAPCephalopod
extends EntityWaterMobPathing {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    protected float rotationVelocity;
    protected float rotateSpeed;
    protected float randomMotionSpeed;
    protected float randomMotionVecX;
    protected float randomMotionVecY;
    protected float randomMotionVecZ;

    public EntityBAPCephalopod(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.rotationVelocity = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.05f;
    }

    public void m_6710_(LivingEntity entitylivingbaseIn) {
        if (!this.isPeaceful()) {
            super.m_6710_(entitylivingbaseIn);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.f_19853_.f_46443_) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.f_19796_.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
                }
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            }
        }
        if (this.m_20072_()) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = Mth.m_14031_((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.f_19853_.f_46443_ && this.m_21573_().m_26571_()) {
                this.m_20334_(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vec3 vec3d = this.m_20184_();
            double f1 = Math.sqrt(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_);
            this.f_20883_ += (-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f - this.f_20883_) * 0.1f;
            this.m_146922_(this.f_20883_);
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)Mth.m_14136_((double)f1, (double)vec3d.f_82480_)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = Mth.m_14154_((float)Mth.m_14031_((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.f_19853_.f_46443_) {
                double d0 = this.m_20184_().f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    d0 = 0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1);
                } else if (!this.m_20068_()) {
                    d0 -= 0.08;
                }
                this.m_20334_(0.0, d0 * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.squirtInk();
            return true;
        }
        return false;
    }

    public boolean isPeaceful() {
        return this.f_19853_.m_46791_() == Difficulty.PEACEFUL;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12440_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected Vec3 getInkAngle(Vec3 vec) {
        Vec3 vec3d = vec.m_82496_(this.prevSquidPitch * ((float)Math.PI / 180));
        vec3d = vec3d.m_82524_(-this.f_20884_ * ((float)Math.PI / 180));
        return vec3d;
    }

    protected void squirtInk() {
        this.m_5496_(SoundEvents.f_12441_, this.m_6121_(), this.m_6100_());
        Vec3 vec3d = this.getInkAngle(new Vec3(0.0, -1.0, 0.0)).m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        for (int i = 0; i < 30; ++i) {
            Vec3 vec3d1 = this.getInkAngle(new Vec3((double)this.f_19796_.nextFloat() * 0.6 - 0.3, -1.0, (double)this.f_19796_.nextFloat() * 0.6 - 0.3));
            Vec3 vec3d2 = vec3d1.m_82490_(0.3 + (double)(this.f_19796_.nextFloat() * 2.0f));
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123765_, vec3d.f_82479_, vec3d.f_82480_ + 0.5, vec3d.f_82481_, 0, vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, (double)0.1f);
        }
    }

    public void setMovementVector(float x, float y, float z) {
        this.randomMotionVecX = x;
        this.randomMotionVecY = y;
        this.randomMotionVecZ = z;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public static class MoveRandomGoal
    extends Goal {
        private final EntityBAPCephalopod cephalopod;

        public MoveRandomGoal(EntityBAPCephalopod squid) {
            this.cephalopod = squid;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.cephalopod.m_5448_() == null;
        }

        public boolean m_8045_() {
            return this.cephalopod.m_5448_() == null;
        }

        public void m_8037_() {
            int i = this.cephalopod.m_21216_();
            if (i > 100) {
                this.cephalopod.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.cephalopod.m_21187_().nextInt(50) == 0 || !this.cephalopod.f_19798_ || !this.cephalopod.hasMovementVector()) {
                float f = this.cephalopod.m_21187_().nextFloat() * ((float)Math.PI * 2);
                float f1 = Mth.m_14089_((float)f) * 0.2f;
                float f2 = -0.1f + this.cephalopod.m_21187_().nextFloat() * 0.2f;
                float f3 = Mth.m_14031_((float)f) * 0.2f;
                this.cephalopod.setMovementVector(f1, f2, f3);
            }
        }
    }
}

