/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.item;

import dev.itsmeow.betteranimalsplus.BetterAnimalsPlusMod;
import dev.itsmeow.betteranimalsplus.common.item.ItemModeledArmor;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemCape
extends ItemModeledArmor {
    public static CanEquipFunction can_equip = (s, a, e) -> true;
    public final Item repairItem;
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource blockSource, ItemStack itemStack) {
            return ItemCape.dispenseArmor(blockSource, itemStack) ? itemStack : super.m_7498_(blockSource, itemStack);
        }
    };

    public static boolean dispenseArmor(BlockSource blockSource, ItemStack stack) {
        BlockPos blockPos = blockSource.m_7961_().m_142300_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = blockSource.m_7727_().m_6443_(LivingEntity.class, new AABB(blockPos), EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(stack)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity entity = (LivingEntity)list.get(0);
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!can_equip.canEquip(stack, slot, (Entity)entity)) {
            return false;
        }
        ItemStack itemStack2 = stack.m_41620_(1);
        entity.m_8061_(slot, itemStack2);
        if (entity instanceof Mob) {
            ((Mob)entity).m_21409_(slot, 2.0f);
            ((Mob)entity).m_21530_();
        }
        return true;
    }

    public ItemCape(Item repairItem, ArmorMaterial material) {
        super(material, EquipmentSlot.CHEST, new Item.Properties().m_41491_(BetterAnimalsPlusMod.TAB));
        this.repairItem = repairItem;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.CHEST && can_equip.canEquip(stack, armorType, entity);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == this.repairItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <A extends HumanoidModel<?>> A displays(A armorModel, EquipmentSlot slot) {
        armorModel.f_102808_.f_104207_ = false;
        armorModel.f_102809_.f_104207_ = false;
        armorModel.f_102810_.f_104207_ = true;
        armorModel.f_102811_.f_104207_ = false;
        armorModel.f_102812_.f_104207_ = false;
        armorModel.f_102813_.f_104207_ = false;
        armorModel.f_102814_.f_104207_ = false;
        return armorModel;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        EquipmentSlot slot;
        ItemStack stack = player.m_21120_(interactionHand);
        if (!can_equip.canEquip(stack, slot = Mob.m_147233_((ItemStack)stack), (Entity)player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ItemStack inSlot = player.m_6844_(slot);
        if (inSlot.m_41619_()) {
            player.m_8061_(slot, stack.m_41777_());
            stack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @FunctionalInterface
    public static interface CanEquipFunction {
        public boolean canEquip(ItemStack var1, EquipmentSlot var2, Entity var3);
    }
}

