/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.compat.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.itsmeow.betteranimalsplus.common.item.ItemCape;
import dev.itsmeow.betteranimalsplus.common.item.ItemModeledArmor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;

public record CurioCape(ItemStack stack) implements ICurio
{
    public ItemStack getStack() {
        return this.stack;
    }

    public boolean canEquip(SlotContext context) {
        ItemStack chest = context.entity().m_6844_(EquipmentSlot.CHEST);
        return (chest.m_41619_() || !(chest.m_41720_() instanceof ItemCape)) && !CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.m_41720_() instanceof ItemCape, context.entity()).isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements ICurioRenderer {
        protected static final Map<String, HumanoidModel<LivingEntity>> models = new HashMap<String, HumanoidModel<LivingEntity>>();
        private String modelKey;

        public Renderer(String modelKey) {
            this.modelKey = modelKey;
        }

        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            Item item = stack.m_41720_();
            if (item instanceof ItemModeledArmor) {
                HumanoidModel model;
                HumanoidModel parentModel;
                ItemModeledArmor item2 = (ItemModeledArmor)item;
                HumanoidModel humanoidModel = parentModel = renderLayerParent.m_7200_() instanceof HumanoidModel ? (HumanoidModel)renderLayerParent.m_7200_() : null;
                if (!models.containsKey(this.modelKey)) {
                    model = item2.getArmorModel(slotContext.entity(), stack, EquipmentSlot.CHEST, parentModel);
                    models.put(this.modelKey, (HumanoidModel<LivingEntity>)model);
                } else {
                    model = models.get(this.modelKey);
                }
                ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)slotContext.entity());
                ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)slotContext.entity());
                ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
                String texture = ((ArmorItem)stack.m_41720_()).m_40401_().m_6082_();
                String domain = "minecraft";
                int idx = texture.indexOf(58);
                if (idx != -1) {
                    domain = texture.substring(0, idx);
                    texture = texture.substring(idx + 1);
                }
                String tex = String.format("%s:textures/models/armor/%s_layer_%d.png", domain, texture, 1);
                VertexConsumer ivertexbuilder = renderTypeBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)new ResourceLocation(tex)));
                model.m_6973_(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.m_7695_(matrixStack, ivertexbuilder, light, LivingEntityRenderer.m_115338_((LivingEntity)slotContext.entity(), (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

