/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.architectury.utils.GameInstance;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityRegistrarHandler;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;

public class IMDLib {
    private static Optional<Registries> REGISTRIES = Optional.empty();
    private static MinecraftServer SERVER;

    public static Optional<Registries> getRegistries() {
        return REGISTRIES;
    }

    public static <T> Registrar<T> getRegistry(ResourceKey<Registry<T>> key) {
        if (!IMDLib.getRegistries().isPresent()) {
            throw new RuntimeException("Registries have not been initialized yet! Call IMDLib.setRegistry(modid) or use IMDLib.entityHandler(modid)");
        }
        return IMDLib.getRegistries().get().get(key);
    }

    public static void setRegistry(String modid) {
        REGISTRIES = Optional.of(Registries.get((String)modid));
    }

    public static void setStaticServerInstance(MinecraftServer server) {
        SERVER = server;
    }

    public static MinecraftServer getStaticServerInstance() {
        if (SERVER == null) {
            MinecraftServer s = GameInstance.getServer();
            if (s != null) {
                SERVER = s;
                return SERVER;
            }
            throw new RuntimeException("Server not initialized yet! Call IMDLib.setStaticServerInstance(server) or use IMDLib.entityHandler(modid)");
        }
        return SERVER;
    }

    public static EntityRegistrarHandler entityHandler(String modid) {
        IMDLib.setRegistry(modid);
        return new EntityRegistrarHandler(modid);
    }
}

