/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces;

import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IContainerEntity;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public interface IVariantTypes<T extends Mob>
extends IContainerEntity<T> {
    default public void registerTypeKey() {
        this.getImplementation().m_20088_().m_135372_(this.getContainer().getVariantDataKey(), (Object)((IVariant)this.getContainer().getVariants().get(0)).getName());
    }

    default public String getVariantString() {
        return (String)this.getImplementation().m_20088_().m_135370_(this.getContainer().getVariantDataKey());
    }

    default public IVariantTypes<T> setType(String variantKey) {
        if (!this.getContainer().getVariantForName(variantKey).isPresent()) {
            variantKey = this.getRandomType().getName();
        }
        this.getImplementation().m_20088_().m_135381_(this.getContainer().getVariantDataKey(), (Object)variantKey);
        return this;
    }

    default public IVariantTypes<T> setType(IVariant variant) {
        this.getImplementation().m_20088_().m_135381_(this.getContainer().getVariantDataKey(), (Object)variant.getName());
        return this;
    }

    default public void writeType(CompoundTag compound) {
        String variantKey = this.getVariantNameOrEmpty();
        if (variantKey.isEmpty()) {
            variantKey = this.getRandomType().getName();
        }
        compound.m_128359_("VariantId", variantKey);
    }

    default public void readType(CompoundTag compound) {
        this.setType(compound.m_128461_("VariantId"));
    }

    default public IVariant getOffspringType(IVariantTypes<?> parent1, IVariantTypes<?> parent2) {
        if (parent1 == null || parent2 == null) {
            if (parent1 == null && parent2 != null) {
                return parent2.getVariant().orElseGet(this::getRandomType);
            }
            if (parent1 != null) {
                return parent1.getVariant().orElseGet(this::getRandomType);
            }
            return this.getRandomType();
        }
        return this.getImplementation().m_21187_().nextBoolean() ? parent1.getVariant().orElseGet(() -> parent2.getVariant().orElseGet(this::getRandomType)) : parent2.getVariant().orElseGet(() -> parent1.getVariant().orElseGet(this::getRandomType));
    }

    default public IVariant getRandomType() {
        return (IVariant)this.getContainer().getVariants().get(this.getImplementation().m_21187_().nextInt(this.getContainer().getVariantMax()));
    }

    @Nullable
    default public SpawnGroupData initData(LevelAccessor world, MobSpawnType reason, SpawnGroupData livingdata) {
        return this.dataFromVariant(this.getRandomType(), livingdata);
    }

    @Nullable
    default public SpawnGroupData initAgeableData(LevelAccessor world, MobSpawnType reason, SpawnGroupData livingdata) {
        return this.ageableDataFromVariant(this.getRandomType(), livingdata);
    }

    default public Optional<IVariant> getVariant() {
        return this.getContainer().getVariantForName(this.getVariantString());
    }

    @Nullable
    default public ResourceLocation getVariantTextureOrNull() {
        return this.getVariant().map(v -> v.getTexture((Entity)this.getImplementation())).orElse(null);
    }

    default public String getVariantNameOrEmpty() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getName() : "";
    }

    default public SpawnGroupData ageableDataFromVariant(IVariant variant, SpawnGroupData livingdata) {
        if (livingdata instanceof AgeableTypeData) {
            variant = ((AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof AgeableMob.AgeableMobGroupData ? new AgeableTypeData((AgeableMob.AgeableMobGroupData)livingdata, variant) : new AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    default public SpawnGroupData dataFromVariant(IVariant variant, SpawnGroupData livingdata) {
        if (livingdata instanceof TypeData) {
            variant = ((TypeData)livingdata).typeData;
        } else {
            livingdata = new TypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    public static class AgeableTypeData
    extends AgeableMob.AgeableMobGroupData {
        public IVariant typeData;
        private int indexInGroup = 0;
        private boolean canBabySpawn = true;
        private float babySpawnProbability = 0.05f;

        public AgeableTypeData(IVariant type) {
            super(false);
            this.typeData = type;
        }

        public AgeableTypeData(AgeableMob.AgeableMobGroupData data, IVariant type) {
            super(false);
            this.typeData = type;
            this.indexInGroup = data.m_146777_();
            this.canBabySpawn = data.m_146779_();
            this.babySpawnProbability = data.m_146780_();
        }

        public int m_146777_() {
            return this.indexInGroup;
        }

        public boolean m_146779_() {
            return this.canBabySpawn;
        }

        public float m_146780_() {
            return this.babySpawnProbability;
        }
    }

    public static class TypeData
    implements SpawnGroupData {
        public IVariant typeData;

        public TypeData(IVariant type) {
            this.typeData = type;
        }
    }
}

