/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigGeneralForge {
    public final ForgeConfigSpec.ConfigValue<Boolean> enableHeads;
    public final ForgeConfigSpec.ConfigValue<Boolean> removeVanillaDungeons;
    public final ForgeConfigSpec.ConfigValue<Boolean> enableNetherBlocks;

    public ConfigGeneralForge(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.comment("##########################################################################################################\n# General settings.\n##########################################################################################################").push("General");
        this.enableHeads = BUILDER.comment("Whether or not dungeons should be allowed to place skeleton skulls and other mob heads.\nThis option may be useful for some modpack creators.\nDefault: true".indent(1)).worldRestart().define("Enable Skulls & Heads", true);
        this.removeVanillaDungeons = BUILDER.comment("Whether or not vanilla dungeons should be prevented from spawning in the world.\nIt is recommended to disable these, since the Small Dungeons are very similar in design.\nDefault: true".indent(1)).worldRestart().define("Remove Vanilla Dungeons", true);
        this.enableNetherBlocks = BUILDER.comment("Some dungeons can rarely spawn Nether-related blocks such as soul sand, soul campfires, and soul lanterns.\nNote that the blocks will be purely decorative - nothing progression-breaking like Ancient Debris.\nSet this to false to prevent any Nether-related blocks from spawning in dungeons.\nThis option may be useful for some modpack creators.\nDefault: true".indent(1)).worldRestart().define("Enable Nether Blocks in Dungeons", true);
        BUILDER.pop();
    }
}

