/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit.util;

import com.natamus.collective.functions.NumberFunctions;
import com.natamus.collective.functions.PlayerFunctions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    public static String startergearstring = "";
    private static String workspace_path = System.getProperty("user.dir");
    private static final String dirpath = workspace_path + File.separator + "config" + File.separator + "starterkit";

    public static void getOrCreateGearConfig(boolean first) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            String configstring = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "starterkit.txt", new String[0])));
            if (configstring.startsWith("'")) {
                startergearstring = configstring;
            } else {
                HashMap<String, ItemStack> simplegear = new HashMap<String, ItemStack>();
                for (String line : configstring.split(",")) {
                    String[] itemspl;
                    String[] linespl = line.replace(" ", "").trim().split(":\"");
                    if (linespl.length < 2) continue;
                    int amount = 1;
                    String slotstring = linespl[0].replace("\"", "").trim();
                    String itemstring = linespl[1].replace("\"", "").trim();
                    if (itemstring.contains("-") && (itemspl = itemstring.split("-")).length > 1) {
                        itemstring = itemspl[0];
                        if (NumberFunctions.isNumeric((String)itemspl[1])) {
                            amount = Integer.parseInt(itemspl[1]);
                        }
                    }
                    Item item = null;
                    ResourceLocation itemloc = new ResourceLocation(itemstring);
                    if (ForgeRegistries.ITEMS.containsKey(itemloc)) {
                        item = (Item)ForgeRegistries.ITEMS.getValue(itemloc);
                    } else {
                        if (!ForgeRegistries.BLOCKS.containsKey(itemloc)) continue;
                        Block block = (Block)ForgeRegistries.BLOCKS.getValue(itemloc);
                        item = block.m_5456_();
                    }
                    if (item == null) continue;
                    simplegear.put(slotstring, new ItemStack((ItemLike)item, amount));
                }
                startergearstring = PlayerFunctions.getPlayerGearStringFromHashMap(simplegear);
            }
        } else {
            dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", "UTF-8");
            writer.println("\"offhand\" : \"minecraft:shield\",");
            writer.println("\"head\" : \"\",");
            writer.println("\"chest\" : \"\",");
            writer.println("\"legs\" : \"\",");
            writer.println("\"feet\" : \"minecraft:leather_boots\",");
            NonNullList emptyinventory = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
            for (int i = 0; i < emptyinventory.size(); ++i) {
                String itemstring = "";
                if (i == 0) {
                    itemstring = "minecraft:wooden_sword";
                } else if (i == 1) {
                    itemstring = "minecraft:bread-9";
                }
                writer.println(i + " : \"" + itemstring + "\",");
            }
            writer.close();
            if (first) {
                Util.getOrCreateGearConfig(false);
            }
        }
    }

    public static boolean createGearConfigFromGearString(String gearstring) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            File renamedfile = new File(dirpath + File.separator + "starterkit-old.txt");
            int r = 0;
            while (renamedfile.exists()) {
                renamedfile = new File(dirpath + File.separator + "starterkit-old_" + r + ".txt");
                ++r;
            }
            file.renameTo(renamedfile);
        } else {
            dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", "UTF-8");
        writer.println(gearstring);
        writer.close();
        Util.getOrCreateGearConfig(false);
        return true;
    }

    public static void setStarterKit(Player player) {
        if (startergearstring == "") {
            return;
        }
        PlayerFunctions.setPlayerGearFromString((Player)player, (String)startergearstring);
    }

    public static boolean processNewGearString(String gearstring) {
        try {
            if (Util.createGearConfigFromGearString(gearstring)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

