/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.mixin.structures.PoolElementStructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMonumentConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MonumentPieces;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MonumentStructure<C extends RSMonumentConfig>
extends AbstractBaseStructure<C> {
    public MonumentStructure(Codec<C> codec) {
        super(codec, MonumentStructure::isMonumentFeatureChunk, MonumentStructure::generateMonumentPieces);
    }

    protected static <CC extends RSMonumentConfig> boolean isMonumentFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        ChunkPos chunkPos = context.f_197355_();
        RSMonumentConfig config = (RSMonumentConfig)context.f_197356_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            for (int curChunkX = chunkPos.f_45578_ - config.biomeRadius; curChunkX <= chunkPos.f_45578_ + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.biomeRadius; curChunkZ <= chunkPos.f_45579_ + config.biomeRadius; ++curChunkZ) {
                    int yValue = config.fixedYSpawn.orElse(context.f_197352_().m_156174_(curChunkX << 4, curChunkZ << 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()));
                    Holder biome = context.f_197353_().m_203407_(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.f_197352_().m_183403_());
                    if (context.f_197358_().test(biome)) continue;
                    return false;
                }
            }
        }
        for (ResourceKey<StructureSet> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.f_197352_().m_212265_(structureSetToAvoid, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends RSMonumentConfig> Optional<PieceGenerator<CC>> generateMonumentPieces(PieceGeneratorSupplier.Context<CC> context) {
        int finalheight;
        RSMonumentConfig config = (RSMonumentConfig)context.f_197356_();
        ChunkPos chunkPos = context.f_197355_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        BlockPos centerPoint = chunkPos.m_151394_(0);
        if (config.fixedYSpawn.isPresent()) {
            finalheight = config.fixedYSpawn.get();
        } else {
            int centerHight;
            float centerWeight = config.centerTerrainHeightWeight.orElse(Float.valueOf(1.0f)).floatValue();
            int highestLandPos = centerHight = context.f_197352_().m_156179_(centerPoint.m_123341_(), centerPoint.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(centerPoint.m_123341_() + 29, centerPoint.m_123343_() + 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(centerPoint.m_123341_() - 29, centerPoint.m_123343_() + 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(centerPoint.m_123341_() + 29, centerPoint.m_123343_() - 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()));
            highestLandPos = Math.min(highestLandPos, context.f_197352_().m_156179_(centerPoint.m_123341_() - 29, centerPoint.m_123343_() - 29, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()));
            finalheight = (int)((float)(highestLandPos - centerHight) / centerWeight) + centerHight;
        }
        if (finalheight <= context.f_197352_().m_142062_()) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            List<StructurePiece> list = MonumentPieces.createMonumentBuilding(context.f_197360_(), context.f_197359_(), (Random)random, centerPoint.m_123341_(), finalheight, centerPoint.m_123343_(), config);
            Rotation rotation = Rotation.m_55956_((Random)random);
            BlockPos mainOffset = new BlockPos(-29, 0, -29).m_7954_(rotation);
            for (StructurePiece structurePiece : list) {
                if (!(structurePiece instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)structurePiece;
                ((PoolElementStructurePieceAccessor)poolPiece).setRotation(poolPiece.m_6830_().m_55952_(rotation));
                BlockPos piecePos = poolPiece.m_72646_();
                BlockPos offsetPos = piecePos.m_141950_((Vec3i)centerPoint);
                BlockPos rotatedOffset = offsetPos.m_7954_(rotation);
                poolPiece.m_6324_(rotatedOffset.m_123341_() - offsetPos.m_123341_(), 0, rotatedOffset.m_123343_() - offsetPos.m_123343_());
                poolPiece.m_6324_(mainOffset.m_123341_(), 0, mainOffset.m_123343_());
                StructurePoolElement patt7064$temp = poolPiece.m_209918_();
                if (!(patt7064$temp instanceof SinglePoolElement)) continue;
                SinglePoolElement singlePoolElement = (SinglePoolElement)patt7064$temp;
                StructureTemplate structuretemplate = ((SinglePoolElementAccessor)singlePoolElement).callGetTemplate(context.f_197359_());
                ((StructurePieceAccessor)poolPiece).setBoundingBox(structuretemplate.m_74633_(new StructurePlaceSettings().m_74379_(rotation), poolPiece.m_72646_()));
            }
            list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }
}

