/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render_layer;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.IRegistryDelegate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemBlockRenderTypes.class})
public class MixinRenderLayers {
    @Shadow
    private static boolean f_109277_;
    @Shadow
    @Final
    private static Map<IRegistryDelegate<Block>, Predicate<RenderType>> blockRenderChecks;
    @Shadow
    @Final
    private static Map<IRegistryDelegate<Fluid>, Predicate<RenderType>> fluidRenderChecks;

    @Inject(remap=false, at={@At(value="HEAD")}, method={"canRenderInLayer(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/client/renderer/RenderType;)Z"}, cancellable=true)
    private static void render(BlockState state, RenderType type, CallbackInfoReturnable<Boolean> cir) {
        Block block = state.m_60734_();
        if (block instanceof LeavesBlock) {
            cir.setReturnValue((Object)(f_109277_ ? type == RenderType.m_110457_() : type == RenderType.m_110451_()));
        } else {
            Predicate<RenderType> rendertype = blockRenderChecks.get(block.delegate);
            cir.setReturnValue((Object)(rendertype != null ? rendertype.test(type) : type == RenderType.m_110451_()));
        }
    }

    @Inject(remap=false, at={@At(value="HEAD")}, method={"canRenderInLayer(Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/client/renderer/RenderType;)Z"}, cancellable=true)
    private static void render(FluidState fluid, RenderType type, CallbackInfoReturnable<Boolean> cir) {
        Predicate<RenderType> rendertype = fluidRenderChecks.get(fluid.m_76152_().delegate);
        cir.setReturnValue((Object)(rendertype != null ? rendertype.test(type) : type == RenderType.m_110451_()));
    }
}

