/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.functions.BlockFunctions;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallGrassBlock;

public class CompareBlockFunctions {
    public static boolean blockIsInRegistryHolder(Block block, TagKey<Block> tagKey) {
        return block.m_204297_().m_203656_(tagKey);
    }

    public static boolean isStoneBlock(Block block) {
        return CompareBlockFunctions.blockIsInRegistryHolder(block, (TagKey<Block>)BlockTags.f_13061_);
    }

    public static boolean isNetherStoneBlock(Block block) {
        return CompareBlockFunctions.blockIsInRegistryHolder(block, (TagKey<Block>)BlockTags.f_13062_);
    }

    public static boolean isTreeLeaf(Block block, boolean withNetherVariants) {
        if (CompareBlockFunctions.blockIsInRegistryHolder(block, (TagKey<Block>)BlockTags.f_13035_) || block instanceof LeavesBlock) {
            return true;
        }
        if (withNetherVariants && (block.equals(Blocks.f_50451_) || block.equals(Blocks.f_50692_) || block.equals(Blocks.f_50701_))) {
            return true;
        }
        if (block instanceof BushBlock) {
            return !(block instanceof CropBlock) && !(block instanceof DeadBushBlock) && !(block instanceof DoublePlantBlock) && !(block instanceof FlowerBlock) && !(block instanceof SaplingBlock) && !(block instanceof StemBlock) && !(block instanceof AttachedStemBlock) && !(block instanceof SweetBerryBushBlock) && !(block instanceof TallGrassBlock);
        }
        return false;
    }

    public static boolean isTreeLeaf(Block block) {
        return CompareBlockFunctions.isTreeLeaf(block, true);
    }

    public static boolean isTreeLog(Block block) {
        return CompareBlockFunctions.blockIsInRegistryHolder(block, (TagKey<Block>)BlockTags.f_13106_) || block instanceof RotatedPillarBlock;
    }

    public static boolean isSapling(Block block) {
        return CompareBlockFunctions.blockIsInRegistryHolder(block, (TagKey<Block>)BlockTags.f_13104_) || block instanceof SaplingBlock;
    }

    public static boolean isDirtBlock(Block block) {
        return block.equals(Blocks.f_50440_) || block.equals(Blocks.f_50493_) || block.equals(Blocks.f_50546_) || block.equals(Blocks.f_50599_);
    }

    public static boolean isPortalBlock(Block block) {
        return block instanceof NetherPortalBlock || BlockFunctions.blockToReadableString(block).equals("portal placeholder");
    }

    public static boolean isAirOrOverwritableBlock(Block block) {
        return block.equals(Blocks.f_50016_) || block instanceof BushBlock || block instanceof SnowLayerBlock;
    }
}

