/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.deathcounter.common.core;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import me.ichun.mods.deathcounter.common.core.CommandDeathCounter;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

@Mod(modid="deathcounter", name="DeathCounter", version="1.1.0", acceptableRemoteVersions="*", dependencies="required-after:forge@[13.19.0.2141,)", acceptedMinecraftVersions="[1.12,1.13)")
public class DeathCounter {
    public static final String version = "1.1.0";
    public static File saveDir;
    public static HashMap<String, Integer> deathCounter;
    public static ArrayList<String> ranking;
    public static int message;
    public static int leaderboardCount;
    public static int outputToTextFile;
    public static int singleSession;
    @Mod.Instance(value="deathcounter")
    public static DeathCounter instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        message = config.getInt("message", "deathcounter", 2, 0, 2, "Death Count Messages?\n0 = Disable\n1 = Short message\n2 = Long message");
        leaderboardCount = config.getInt("leaderboardCount", "deathcounter", 5, 0, 20, "Number of names to show in the leaderboards");
        singleSession = config.getInt("singleSession", "deathcounter", 0, 0, 1, "Do not save deaths in save folder?\n0 = No\n1 = Yes");
        outputToTextFile = config.getInt("outputToTextFile", "deathcounter", 1, 0, 1, "Output deaths to text file in save folder?\n(This is overridden to 0 by the singleSession config)\n0 = No\n1 = Yes");
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager manager = event.getServer().func_71187_D();
        if (manager instanceof CommandHandler) {
            CommandHandler handler = (CommandHandler)manager;
            handler.func_71560_a((ICommand)new CommandDeathCounter());
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        deathCounter.clear();
        ranking.clear();
        this.loadDeaths(DimensionManager.getWorld((int)0));
        this.sortRanking();
    }

    public void loadDeaths(WorldServer world) {
        File[] files;
        File dir = new File(world.getChunkSaveLocation(), "deathCounter");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        saveDir = dir;
        for (File file : files = dir.listFiles()) {
            if (!file.getName().endsWith(".dat")) continue;
            String user = file.getName().substring(0, file.getName().length() - 4);
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                deathCounter.put(user, tag.func_74762_e("deaths"));
            }
            catch (EOFException e) {
                DeathCounter.console("File for " + user + " is corrupted. Flushing.", Level.WARN);
            }
            catch (IOException e) {
                DeathCounter.console("Failed to read file for " + user + ". Flushing.", Level.WARN);
            }
        }
    }

    public void sortRanking() {
        for (Map.Entry<String, Integer> e : deathCounter.entrySet()) {
            ranking.remove(e.getKey());
            if (e.getValue() <= 0) continue;
            for (int i = 0; i < ranking.size(); ++i) {
                if (this.getDeathCount(ranking.get(i)) > e.getValue()) continue;
                ranking.add(i, e.getKey());
                break;
            }
            if (ranking.contains(e.getKey())) continue;
            ranking.add(e.getKey());
        }
        if (singleSession != 1 && outputToTextFile == 1) {
            Properties s = new Properties();
            File text = new File(saveDir, "deaths.txt");
            if (text.isDirectory()) {
                return;
            }
            for (Map.Entry<String, Integer> e : deathCounter.entrySet()) {
                s.setProperty(e.getKey(), Integer.toString(e.getValue()));
            }
            try (FileOutputStream fos = new FileOutputStream(text);){
                if (!text.exists()) {
                    text.createNewFile();
                }
                s.store(fos, null);
            }
            catch (IOException e) {
                DeathCounter.console("Error writing deaths.txt", Level.WARN);
            }
        }
    }

    public void addDeath(EntityPlayer player) {
        int deaths = this.getDeathCount(player.func_70005_c_()) + 1;
        deathCounter.put(player.func_70005_c_(), deaths);
        this.sortRanking();
        if (singleSession == 1) {
            return;
        }
        File file = new File(saveDir, player.func_70005_c_() + ".dat");
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("deaths", deaths);
        try (FileOutputStream fos = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)fos);
        }
        catch (IOException ioexception) {
            DeathCounter.console("Failed to save death count for " + player.func_70005_c_(), Level.WARN);
        }
    }

    public boolean clearDeath(String s) {
        if (s == null) {
            File[] files;
            boolean success = true;
            for (File file : files = saveDir.listFiles()) {
                if (!file.getName().endsWith(".dat") || file.delete()) continue;
                success = false;
            }
            deathCounter.clear();
            ranking.clear();
            return success;
        }
        File file = new File(saveDir, s + ".dat");
        if (file.exists()) {
            deathCounter.remove(s);
            this.sortRanking();
            return file.delete();
        }
        return false;
    }

    public int getDeathCount(String s) {
        try {
            return deathCounter.get(s);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public int getDisplayedRank(String s) {
        if (ranking.contains(s)) {
            for (int i = 0; i < ranking.size(); ++i) {
                if (!ranking.get(i).equals(s)) continue;
                int rank = i;
                int deaths = this.getDeathCount(s);
                while (i > 0 && this.getDeathCount(ranking.get(--i)) == deaths) {
                    --rank;
                }
                return rank + 1;
            }
        }
        return ranking.size() + 1;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(event.getEntityLiving().func_70005_c_()) != null) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            this.addDeath(player);
            if (message > 0) {
                if (message == 1) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("dc.message.deathAndRank", new Object[]{this.getDeathCount(player.func_70005_c_()), this.getDisplayedRank(player.func_70005_c_())}), false);
                }
                if (message == 2) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("dc.message.death", new Object[]{this.getDeathCount(player.func_70005_c_())}), false);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("dc.message.rank", new Object[]{this.getDisplayedRank(player.func_70005_c_())}), false);
                }
            }
        }
    }

    @SubscribeEvent
    public void onChatEvent(ServerChatEvent event) {
        if (event.getMessage().toLowerCase().toLowerCase().startsWith("!dc") || event.getMessage().toLowerCase().toLowerCase().startsWith("!deathcounter")) {
            CommandDeathCounter.broadcastLeaderboard(event.getUsername());
            event.setCanceled(true);
        }
    }

    public static void console(String s, Level logLevel) {
        FMLLog.log((String)"DeathCounter", (Level)logLevel, (String)"%s", (Object[])new Object[]{s});
    }

    static {
        deathCounter = new HashMap();
        ranking = new ArrayList();
    }
}

