/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import cofh.api.item.IToolQuiver;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.util.TFCrafting;
import cofh.thermalinnovation.ThermalInnovation;
import cofh.thermalinnovation.item.ItemMultiPotion;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuiver
extends ItemMultiPotion
implements IInitializer,
IToolQuiver {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int CAPACITY_ARROW_BASE = 40;
    public static final int CAPACITY_FLUID_BASE = 2000;
    public static final int MB_PER_ARROW = 50;
    public static final int[] CAPACITY_ARROW = new int[]{1, 3, 6, 10, 15};
    public static final int[] CAPACITY_FLUID = new int[]{1, 3, 6, 10, 15};
    public static boolean enable = true;
    public static ItemStack quiverBasic;
    public static ItemStack quiverHardened;
    public static ItemStack quiverReinforced;
    public static ItemStack quiverSignalum;
    public static ItemStack quiverResonant;
    public static ItemStack quiverCreative;

    public ItemQuiver() {
        super("thermalinnovation");
        this.func_77655_b("quiver");
        this.func_77637_a(ThermalInnovation.tabTools);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalinnovation.quiver.a.0"));
        tooltip.add(StringHelper.localize((String)"info.thermalinnovation.quiver.a.1"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalinnovation.quiver.a.2"));
        tooltip.add(StringHelper.localizeFormat((String)("info.thermalinnovation.quiver.b." + this.getMode(stack)), (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        if (ItemQuiver.isCreative((ItemStack)stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.arrows") + ": " + StringHelper.localize((String)"info.cofh.infinite"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.arrows") + ": " + this.getNumArrows(stack) + " / " + StringHelper.formatNumber((long)this.getMaxArrowCount(stack)));
        }
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null) {
            String color = fluid.getFluid().getRarity().field_77937_e.toString();
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + color + fluid.getFluid().getLocalizedName(fluid) + "\u00a77");
            if (ItemQuiver.isCreative((ItemStack)stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": " + StringHelper.formatNumber((long)fluid.amount) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
            tooltip.add("");
            tooltip.add(StringHelper.localize((String)"info.thermalinnovation.quiver.d"));
            ItemQuiver.addPotionTooltip(fluid.tag, tooltip);
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (ItemQuiver.isCreative((ItemStack)stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable && this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)new ItemStack((Item)this, 1, metadata));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)new ItemStack((Item)this, 1, metadata));
            }
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Arrows", "Fluid"}));
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            ItemStack arrows = ItemQuiver.findArrows(player);
            if (!arrows.func_190926_b() && arrows.func_190916_E() < arrows.func_77976_d()) {
                arrows.func_190917_f(this.removeArrows(stack, arrows.func_77976_d() - arrows.func_190916_E(), false));
            } else {
                arrows = new ItemStack(Items.field_151032_g, Math.min(this.getNumArrows(stack), 64));
                if (ItemQuiver.addToPlayerInventory(player, arrows)) {
                    this.removeArrows(stack, arrows.func_190916_E(), false);
                }
            }
        } else {
            ItemStack arrows = ItemQuiver.findArrows(player);
            arrows.func_190918_g(this.addArrows(stack, arrows.func_190916_E(), false));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int getNumArrows(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return ItemQuiver.isCreative((ItemStack)stack) ? this.getMaxArrowCount(stack) : stack.func_77978_p().func_74762_e("Arrows");
    }

    public int getMaxArrowCount(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int arrows = ((TypeEntry)ItemQuiver.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).arrows;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return arrows + arrows * enchant / 2;
    }

    public int getScaledArrowsStored(ItemStack stack, int scale) {
        return MathHelper.round((double)((long)this.getNumArrows(stack) * (long)scale / (long)this.getMaxArrowCount(stack)));
    }

    public int addArrows(ItemStack stack, int maxArrows, boolean simulate) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int stored = this.getNumArrows(stack);
        int toAdd = Math.min(maxArrows, this.getMaxArrowCount(stack) - stored);
        if (!simulate && !ItemQuiver.isCreative((ItemStack)stack)) {
            stack.func_77978_p().func_74768_a("Arrows", stored += toAdd);
        }
        return toAdd;
    }

    public int removeArrows(ItemStack stack, int maxArrows, boolean simulate) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (ItemQuiver.isCreative((ItemStack)stack)) {
            return maxArrows;
        }
        int stored = Math.min(stack.func_77978_p().func_74762_e("Arrows"), this.getMaxArrowCount(stack));
        int toRemove = Math.min(maxArrows, stored);
        if (!simulate) {
            stack.func_77978_p().func_74768_a("Arrows", stored -= toRemove);
        }
        return toRemove;
    }

    public static ItemStack findArrows(EntityPlayer player) {
        ItemStack offHand = player.func_184592_cb();
        ItemStack mainHand = player.func_184614_ca();
        if (ItemQuiver.isArrow(offHand)) {
            return offHand;
        }
        if (ItemQuiver.isArrow(mainHand)) {
            return mainHand;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!ItemQuiver.isArrow(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isArrow(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151032_g);
    }

    public static boolean addToPlayerInventory(EntityPlayer player, ItemStack stack) {
        if (stack.func_190926_b() || player == null) {
            return false;
        }
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!((ItemStack)inv.field_70462_a.get(i)).func_190926_b()) continue;
            inv.field_70462_a.set(i, (Object)stack.func_77946_l());
            return true;
        }
        return false;
    }

    @Override
    public int getMaxFluidAmount(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemQuiver.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    @Override
    public int colorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 2 && ColorHelper.hasColor0((ItemStack)stack)) {
            return ColorHelper.getColor0((ItemStack)stack);
        }
        if (tintIndex == 3 && ColorHelper.hasColor1((ItemStack)stack)) {
            return ColorHelper.getColor1((ItemStack)stack);
        }
        return super.colorMultiplier(stack, tintIndex);
    }

    public int getMaxColorIndex(ItemStack stack) {
        return 1;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (mode == 1) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187806_ee, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalinnovation.quiver.c." + mode, new Object[0]));
    }

    public EntityArrow createEntityArrow(World world, ItemStack item, EntityLivingBase shooter) {
        FluidStack fluid = this.getFluid(item);
        if (this.getMode(item) == 1 && fluid != null && fluid.amount >= 50) {
            ItemStack arrowStack = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionUtils.func_185187_c((NBTTagCompound)fluid.tag));
            return ((ItemTippedArrow)arrowStack.func_77973_b()).func_185052_a(world, arrowStack, shooter);
        }
        ItemStack arrowStack = new ItemStack(Items.field_151032_g);
        return ((ItemArrow)arrowStack.func_77973_b()).func_185052_a(world, arrowStack, shooter);
    }

    public boolean isEmpty(ItemStack item, EntityLivingBase shooter) {
        if (ItemQuiver.isCreative((ItemStack)item) || shooter instanceof EntityPlayer && ((EntityPlayer)shooter).field_71075_bZ.field_75098_d) {
            return false;
        }
        return this.getNumArrows(item) <= 0;
    }

    public void onArrowFired(ItemStack item, EntityLivingBase shooter) {
        if (shooter instanceof EntityPlayer) {
            boolean creativeMode = ((EntityPlayer)shooter).field_71075_bZ.field_75098_d;
            this.removeArrows(item, 1, creativeMode);
            this.drain(item, 50, this.getMode(item) == 1 && !creativeMode);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("arrows=%s,color0=%s,color1=%s,fill=%s,type=%s", MathHelper.clamp((int)(this.getNumArrows(stack) > 0 ? 1 + this.getScaledArrowsStored(stack, 4) : 0), (int)0, (int)4), ColorHelper.hasColor0((ItemStack)stack) ? 1 : 0, ColorHelper.hasColor1((ItemStack)stack) ? 1 : 0, MathHelper.clamp((int)(this.getFluidAmount(stack) > 0 ? 1 + this.getScaledFluidStored(stack, 12) : 0), (int)0, (int)12), ((TypeEntry)ItemQuiver.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int arrows = 0; arrows < 5; ++arrows) {
                for (int color0 = 0; color0 < 2; ++color0) {
                    for (int color1 = 0; color1 < 2; ++color1) {
                        for (int fill = 0; fill < 13; ++fill) {
                            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("arrows=%s,color0=%s,color1=%s,fill=%s,type=%s", arrows, color0, color1, fill, ((ItemMulti.ItemEntry)entry.getValue()).name))});
                        }
                    }
                }
            }
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("quiver"));
        ThermalInnovation.proxy.addIModelRegister((IModelRegister)this);
        ItemQuiver.config();
        quiverBasic = this.addEntryItem(0, "standard0", CAPACITY_ARROW[0], CAPACITY_FLUID[0], EnumRarity.COMMON);
        quiverHardened = this.addEntryItem(1, "standard1", CAPACITY_ARROW[1], CAPACITY_FLUID[1], EnumRarity.COMMON);
        quiverReinforced = this.addEntryItem(2, "standard2", CAPACITY_ARROW[2], CAPACITY_FLUID[2], EnumRarity.UNCOMMON);
        quiverSignalum = this.addEntryItem(3, "standard3", CAPACITY_ARROW[3], CAPACITY_FLUID[3], EnumRarity.UNCOMMON);
        quiverResonant = this.addEntryItem(4, "standard4", CAPACITY_ARROW[4], CAPACITY_FLUID[4], EnumRarity.RARE);
        quiverCreative = this.addEntryItem(32000, "creative", CAPACITY_ARROW[4], CAPACITY_FLUID[4], EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)quiverBasic, (Object[])new Object[]{"BB ", "XLS", "LXS", Character.valueOf('B'), Items.field_151069_bo, Character.valueOf('L'), "leather", Character.valueOf('S'), "string", Character.valueOf('X'), "ingotCopper"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)quiverHardened, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "nuggetCopper", Character.valueOf('X'), quiverBasic});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)quiverReinforced, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "nuggetInvar", Character.valueOf('X'), quiverHardened});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)quiverSignalum, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "nuggetElectrum", Character.valueOf('X'), quiverReinforced});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)quiverResonant, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "nuggetSignalum", Character.valueOf('X'), quiverSignalum});
        TFCrafting.addPotionFillRecipe((ItemStack)quiverBasic, (Object[])new Object[]{quiverBasic, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)quiverHardened, (Object[])new Object[]{quiverHardened, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)quiverReinforced, (Object[])new Object[]{quiverReinforced, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)quiverSignalum, (Object[])new Object[]{quiverSignalum, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)quiverResonant, (Object[])new Object[]{quiverResonant, "cofh:potion"});
        TFCrafting.addPotionFillRecipe((ItemStack)quiverCreative, (Object[])new Object[]{quiverCreative, "cofh:potion"});
        RecipeHelper.addColorRecipe((ItemStack)quiverBasic, (Object[])new Object[]{quiverBasic, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverHardened, (Object[])new Object[]{quiverHardened, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverReinforced, (Object[])new Object[]{quiverReinforced, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverSignalum, (Object[])new Object[]{quiverSignalum, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverResonant, (Object[])new Object[]{quiverResonant, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverBasic, (Object[])new Object[]{quiverBasic, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverHardened, (Object[])new Object[]{quiverHardened, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverReinforced, (Object[])new Object[]{quiverReinforced, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverSignalum, (Object[])new Object[]{quiverSignalum, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)quiverResonant, (Object[])new Object[]{quiverResonant, "dye", "dye"});
        RecipeHelper.addColorRemoveRecipe((ItemStack)quiverBasic, (Object[])new Object[]{quiverBasic});
        RecipeHelper.addColorRemoveRecipe((ItemStack)quiverHardened, (Object[])new Object[]{quiverHardened});
        RecipeHelper.addColorRemoveRecipe((ItemStack)quiverReinforced, (Object[])new Object[]{quiverReinforced});
        RecipeHelper.addColorRemoveRecipe((ItemStack)quiverSignalum, (Object[])new Object[]{quiverSignalum});
        RecipeHelper.addColorRemoveRecipe((ItemStack)quiverResonant, (Object[])new Object[]{quiverResonant});
        return true;
    }

    private static void config() {
        String category = "Item.Quiver";
        enable = ThermalInnovation.CONFIG.get(category, "Enable", true);
        int capacity = 40;
        String comment = "Adjust this value to change the quantity of arrows stored by a Basic Alchemical Quiver. This base value will scale with item level.";
        capacity = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseArrowCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY_FLUID.length) {
            int n = i++;
            CAPACITY_ARROW[n] = CAPACITY_ARROW[n] * capacity;
        }
        capacity = 2000;
        comment = "Adjust this value to change the amount of Fluid (in mB) stored by a Basic Alchemical Quiver. This base value will scale with item level.";
        capacity = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseFluidCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        i = 0;
        while (i < CAPACITY_FLUID.length) {
            int n = i++;
            CAPACITY_FLUID[n] = CAPACITY_FLUID[n] * capacity;
        }
    }

    private void addEntry(int metadata, String name, int arrows, int capacity) {
        typeMap.put(metadata, (Object)new TypeEntry(name, arrows, capacity));
    }

    private ItemStack addEntryItem(int metadata, String name, int arrows, int capacity, EnumRarity rarity) {
        this.addEntry(metadata, name, arrows, capacity);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int arrows;
        public final int capacity;

        TypeEntry(String name, int arrows, int capacity) {
            this.name = name;
            this.arrows = arrows;
            this.capacity = capacity;
        }
    }
}

